/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class PairOfLongString
implements WritableComparable<PairOfLongString> {
    private long leftElement;
    private String rightElement;

    public PairOfLongString() {
    }

    public PairOfLongString(long left, String right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readLong();
        this.rightElement = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.leftElement);
        Text.writeString((DataOutput)out, (String)this.rightElement);
    }

    public long getLeftElement() {
        return this.leftElement;
    }

    public String getRightElement() {
        return this.rightElement;
    }

    public String getValue() {
        return this.rightElement;
    }

    public long getKey() {
        return this.leftElement;
    }

    public void set(long left, String right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfLongString pair = (PairOfLongString)obj;
        return this.rightElement.equals(pair.getRightElement()) && this.leftElement == pair.getLeftElement();
    }

    public int compareTo(PairOfLongString pair) {
        long pl = pair.getLeftElement();
        String pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement.equals(pr)) {
                return 0;
            }
            return this.rightElement.compareTo(pr);
        }
        return this.leftElement < pl ? -1 : 1;
    }

    public int hashCode() {
        return (int)this.leftElement + this.rightElement.hashCode();
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfLongString clone() {
        return new PairOfLongString(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfLongString.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfLongString.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatLeftValue;
            long thisLeftValue = Comparator.readLong((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readLong((byte[])b2, (int)s2))) {
                int n1 = WritableUtils.decodeVIntSize((byte)b1[s1 + 8]);
                int n2 = WritableUtils.decodeVIntSize((byte)b2[s2 + 8]);
                return Comparator.compareBytes((byte[])b1, (int)(s1 + 8 + n1), (int)(l1 - n1 - 8), (byte[])b2, (int)(s2 + n2 + 8), (int)(l2 - n2 - 8));
            }
            return thisLeftValue < thatLeftValue ? -1 : 1;
        }
    }
}

