/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfLongString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfLongStringTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfLongString pair = new PairOfLongString(1L, "hi");
        Assert.assertEquals((Object)"hi", (Object)pair.getRightElement());
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfLongString origPair = new PairOfLongString(2L, "hi");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfLongString pair = new PairOfLongString();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getRightElement());
        Assert.assertTrue((pair.getLeftElement() == 2L ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfLongString pair1 = new PairOfLongString(1L, "hi");
        PairOfLongString pair2 = new PairOfLongString(1L, "hi");
        PairOfLongString pair3 = new PairOfLongString(0L, "hi");
        PairOfLongString pair4 = new PairOfLongString(0L, "a");
        PairOfLongString pair5 = new PairOfLongString(2L, "hi");
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfLongString.Comparator comparator = new PairOfLongString.Comparator();
        PairOfLongString pair1 = new PairOfLongString(1L, "hi");
        PairOfLongString pair2 = new PairOfLongString(1L, "hi");
        PairOfLongString pair3 = new PairOfLongString(0L, "hi");
        PairOfLongString pair4 = new PairOfLongString(0L, "a");
        PairOfLongString pair5 = new PairOfLongString(2L, "hi");
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfLongStringTest.class);
    }
}

