/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfStringFloat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfStringFloatTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfStringFloat pair = new PairOfStringFloat("hi", 1.0f);
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 1.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfStringFloat origPair = new PairOfStringFloat("hi", 2.0f);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfStringFloat pair = new PairOfStringFloat();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 2.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfStringFloat pair1 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair2 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair3 = new PairOfStringFloat("hi", 0.0f);
        PairOfStringFloat pair4 = new PairOfStringFloat("a", 0.0f);
        PairOfStringFloat pair5 = new PairOfStringFloat("hi", 2.0f);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfStringFloat.Comparator comparator = new PairOfStringFloat.Comparator();
        PairOfStringFloat pair1 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair2 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair3 = new PairOfStringFloat("hi", 0.0f);
        PairOfStringFloat pair4 = new PairOfStringFloat("a", 0.0f);
        PairOfStringFloat pair5 = new PairOfStringFloat("hi", 2.0f);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfStringFloatTest.class);
    }
}

