/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class PairOfStringLong
implements WritableComparable<PairOfStringLong> {
    private String leftElement;
    private long rightElement;

    public PairOfStringLong() {
    }

    public PairOfStringLong(String left, long right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = Text.readString((DataInput)in);
        this.rightElement = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.leftElement);
        out.writeLong(this.rightElement);
    }

    public String getLeftElement() {
        return this.leftElement;
    }

    public long getRightElement() {
        return this.rightElement;
    }

    public String getKey() {
        return this.leftElement;
    }

    public long getValue() {
        return this.rightElement;
    }

    public void set(String left, long right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfStringLong pair = (PairOfStringLong)obj;
        return this.leftElement.equals(pair.getLeftElement()) && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfStringLong pair) {
        String pl = pair.getLeftElement();
        long pr = pair.getRightElement();
        if (this.leftElement.equals(pl)) {
            if (this.rightElement == pr) {
                return 0;
            }
            return this.rightElement < pr ? -1 : 1;
        }
        return this.leftElement.compareTo(pl);
    }

    public int hashCode() {
        return this.leftElement.hashCode() + (int)(this.rightElement % Integer.MAX_VALUE);
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfStringLong clone() {
        return new PairOfStringLong(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfStringLong.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfStringLong.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                long thatRightValue;
                int firstVIntL1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
                int firstVIntL2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
                int firstStrL1 = Comparator.readVInt((byte[])b1, (int)s1);
                int firstStrL2 = Comparator.readVInt((byte[])b2, (int)s2);
                int cmp = Comparator.compareBytes((byte[])b1, (int)(s1 + firstVIntL1), (int)firstStrL1, (byte[])b2, (int)(s2 + firstVIntL2), (int)firstStrL2);
                if (cmp != 0) {
                    return cmp;
                }
                long thisRightValue = Comparator.readLong((byte[])b1, (int)(s1 + firstVIntL1 + firstStrL1));
                return thisRightValue < (thatRightValue = Comparator.readLong((byte[])b2, (int)(s2 + firstVIntL2 + firstStrL2))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

