/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.io.pair.PairOfWritables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class PairOfWritablesTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfWritables<Text, IntWritable> pair1 = new PairOfWritables<Text, IntWritable>(new Text("hi"), new IntWritable(1));
        Assert.assertEquals((Object)new Text("hi"), (Object)pair1.getLeftElement());
        Assert.assertEquals((Object)new IntWritable(1), (Object)pair1.getRightElement());
        PairOfWritables<IntWritable, FloatWritable> pair2 = new PairOfWritables<IntWritable, FloatWritable>(new IntWritable(1), new FloatWritable(1.0f));
        Assert.assertEquals((Object)new IntWritable(1), (Object)pair2.getLeftElement());
        Assert.assertEquals((Object)new FloatWritable(1.0f), (Object)pair2.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfWritables<Text, IntWritable> origPair = new PairOfWritables<Text, IntWritable>(new Text("hi"), new IntWritable(1));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfWritables pair = new PairOfWritables();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)new Text("hi"), pair.getLeftElement());
        Assert.assertEquals((Object)new IntWritable(1), pair.getRightElement());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfWritablesTest.class);
    }
}

