/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.triple;

import edu.umd.cloud9.io.triple.TripleOfIntsString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class TripleOfIntsStringTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        TripleOfIntsString threeIntsString = new TripleOfIntsString(1, 2, "good");
        Assert.assertEquals((long)threeIntsString.getLeftElement(), (long)1L);
        Assert.assertEquals((long)threeIntsString.getMiddleElement(), (long)2L);
        Assert.assertEquals((Object)threeIntsString.getRightElement(), (Object)"good");
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        TripleOfIntsString origThreeIntsString = new TripleOfIntsString(1, 2, "good");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origThreeIntsString.write(dataOut);
        TripleOfIntsString threeIntsString = new TripleOfIntsString();
        threeIntsString.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)threeIntsString.getLeftElement(), (long)1L);
        Assert.assertEquals((long)threeIntsString.getMiddleElement(), (long)2L);
        Assert.assertEquals((Object)threeIntsString.getRightElement(), (Object)"good");
    }

    @org.junit.Test
    public void testComparison() throws IOException {
        TripleOfIntsString threeInts1 = new TripleOfIntsString(1, 2, "good");
        TripleOfIntsString threeInts2 = new TripleOfIntsString(1, 2, "good");
        TripleOfIntsString threeInts3 = new TripleOfIntsString(1, 2, "buddy");
        TripleOfIntsString threeInts4 = new TripleOfIntsString(1, 1, "good");
        TripleOfIntsString threeInts5 = new TripleOfIntsString(0, 2, "good");
        Assert.assertTrue((boolean)threeInts1.equals(threeInts2));
        Assert.assertFalse((boolean)threeInts1.equals(threeInts3));
        Assert.assertTrue((threeInts1.compareTo(threeInts2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts2.compareTo(threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts2.compareTo(threeInts4) > 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TripleOfIntsStringTest.class);
    }
}

