/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.triple;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.triple.TripleOfInts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class TripleOfIntsTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        TripleOfInts threeInts = new TripleOfInts(1, 2, 3);
        Assert.assertEquals((long)threeInts.getLeftElement(), (long)1L);
        Assert.assertEquals((long)threeInts.getMiddleElement(), (long)2L);
        Assert.assertEquals((long)threeInts.getRightElement(), (long)3L);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        TripleOfInts origThreeInts = new TripleOfInts(1, 2, 3);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origThreeInts.write(dataOut);
        TripleOfInts threeInts = new TripleOfInts();
        threeInts.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)threeInts.getLeftElement(), (long)1L);
        Assert.assertEquals((long)threeInts.getMiddleElement(), (long)2L);
        Assert.assertEquals((long)threeInts.getRightElement(), (long)3L);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        TripleOfInts threeInts1 = new TripleOfInts(1, 2, 3);
        TripleOfInts threeInts2 = new TripleOfInts(1, 2, 3);
        TripleOfInts threeInts3 = new TripleOfInts(1, 2, 2);
        TripleOfInts threeInts4 = new TripleOfInts(1, 1, 3);
        TripleOfInts threeInts5 = new TripleOfInts(0, 2, 3);
        Assert.assertTrue((boolean)threeInts1.equals(threeInts2));
        Assert.assertFalse((boolean)threeInts1.equals(threeInts3));
        Assert.assertTrue((threeInts1.compareTo(threeInts2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts1.compareTo(threeInts5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts2.compareTo(threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((threeInts2.compareTo(threeInts4) > 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        TripleOfInts.Comparator comparator = new TripleOfInts.Comparator();
        TripleOfInts threeInts1 = new TripleOfInts(1, 2, 3);
        TripleOfInts threeInts2 = new TripleOfInts(1, 2, 3);
        TripleOfInts threeInts3 = new TripleOfInts(1, 2, 2);
        TripleOfInts threeInts4 = new TripleOfInts(1, 1, 3);
        TripleOfInts threeInts5 = new TripleOfInts(0, 2, 3);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts1, threeInts2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts1, threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts1, threeInts4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts1, threeInts5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts2, threeInts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, threeInts2, threeInts4) > 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TripleOfIntsTest.class);
    }
}

