/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.mapred;

import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class NullMapper
extends MapReduceBase
implements Mapper<NullWritable, NullWritable, NullWritable, NullWritable> {
    private JobConf mConf = null;

    public void configure(JobConf conf) {
        this.mConf = conf;
    }

    public void map(NullWritable key, NullWritable value, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
        Thread pulse = new Thread(new HeartbeatRunnable(reporter));
        pulse.start();
        this.run(this.mConf, reporter);
        pulse.interrupt();
    }

    public abstract void run(JobConf var1, Reporter var2) throws IOException;

    private static class HeartbeatRunnable
    implements Runnable {
        Reporter mReporter;

        public HeartbeatRunnable(Reporter reporter) {
            this.mReporter = reporter;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.mReporter.incrCounter((Enum)Heartbeat.COUNT, 1L);
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    static enum Heartbeat {
        COUNT;

    }
}

