/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.math;

import edu.umd.cloud9.math.Gamma;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class GammaTest {
    public static double PRECISION_3 = 0.001f;
    public static double PRECISION_6 = 1.0E-6f;
    public static double PRECISION_9 = 1.0E-9f;
    public static double PRECISION_12 = 1.0E-12f;

    @org.junit.Test
    public void testDigamma() {
        Assert.assertEquals((double)Gamma.digamma(1000000.0), (double)13.81551005796419, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(100000.0), (double)11.512920464961896, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(10000.0), (double)9.21029037114285, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(1000.0), (double)6.907255195648812, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(100.0), (double)4.600161852738087, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(10.0), (double)2.2517525890667214, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(1.0), (double)-0.5772156649015328, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(0.1), (double)-10.42375494041107, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(0.01), (double)-100.56088545786886, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(0.001), (double)-1000.5755719318336, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.digamma(1.0E-4), (double)-10000.57705117741, (double)PRECISION_6);
        Assert.assertEquals((double)Gamma.digamma(1.0E-5), (double)-100000.57719922789, (double)PRECISION_6);
        Assert.assertEquals((double)Gamma.digamma(-0.001), (double)999.4211381980015, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.digamma(-0.01), (double)99.4062136959443, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.digamma(-0.1), (double)9.245073050052941, (double)PRECISION_12);
    }

    @org.junit.Test
    public void testTrigamma() {
        Assert.assertEquals((double)Gamma.trigamma(1000000.0), (double)1.0000005000001667E-6, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(100000.0), (double)1.0000050000166667E-5, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(10000.0), (double)1.0000500016666666E-4, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(1000.0), (double)0.0010005001666666333, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(100.0), (double)0.010050166663333571, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(10.0), (double)0.10516633568168571, (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.trigamma(1.0), (double)1.6449340668482264, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.trigamma(0.1), (double)101.4332991507927, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.trigamma(0.01), (double)10001.62121352835, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.trigamma(0.001), (double)1000001.6425332422, (double)PRECISION_6);
        Assert.assertEquals((double)Gamma.trigamma(-0.001), (double)1000001.6473416518, (double)PRECISION_6);
        Assert.assertEquals((double)Gamma.trigamma(-0.01), (double)10001.669304101055, (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.trigamma(-0.1), (double)101.92253995947704, (double)PRECISION_9);
    }

    @org.junit.Test
    public void testLogGamma() {
        Assert.assertEquals((double)Gamma.lgamma(1000000.0), (double)cern.jet.stat.Gamma.logGamma((double)1000000.0), (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.lgamma(100000.0), (double)cern.jet.stat.Gamma.logGamma((double)100000.0), (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.lgamma(10000.0), (double)cern.jet.stat.Gamma.logGamma((double)10000.0), (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.lgamma(1000.0), (double)cern.jet.stat.Gamma.logGamma((double)1000.0), (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.lgamma(100.0), (double)cern.jet.stat.Gamma.logGamma((double)100.0), (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.lgamma(10.0), (double)cern.jet.stat.Gamma.logGamma((double)10.0), (double)PRECISION_12);
        Assert.assertEquals((double)Gamma.lgamma(1.0), (double)cern.jet.stat.Gamma.logGamma((double)1.0), (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.lgamma(0.1), (double)cern.jet.stat.Gamma.logGamma((double)0.1), (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.lgamma(0.01), (double)cern.jet.stat.Gamma.logGamma((double)0.01), (double)PRECISION_9);
        Assert.assertEquals((double)Gamma.lgamma(0.001), (double)cern.jet.stat.Gamma.logGamma((double)0.001), (double)PRECISION_6);
    }

    @org.junit.Test
    public void logGammaSpeedTest() {
        int i;
        long time = System.currentTimeMillis();
        for (i = 0; i < 99999; ++i) {
            Gamma.lgamma(i + 1);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < 99999; ++i) {
            Gamma.lanczosLGamma9(i + 1);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < 99999; ++i) {
            Gamma.lanczosLGamma15(i + 1);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < 99999; ++i) {
            Gamma.stirlingLGamma(i + 1);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < 99999; ++i) {
            cern.jet.stat.Gamma.logGamma((double)(i + 1));
        }
        System.out.println(System.currentTimeMillis() - time);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(GammaTest.class);
    }
}

