/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util;

public class FibonacciHeap<T extends Comparable<T>> {
    private Node<T> min;
    private int n;

    public void clear() {
        this.min = null;
        this.n = 0;
    }

    private void consolidate() {
        Node nextW;
        Node[] A = new Node[45];
        Node start = this.min;
        Node w = this.min;
        do {
            Node x = w;
            nextW = w.right;
            int d = x.degree;
            while (A[d] != null) {
                Node y = A[d];
                if (x.isGreaterThan(y)) {
                    Node temp = y;
                    y = x;
                    x = temp;
                }
                if (y == start) {
                    start = start.right;
                }
                if (y == nextW) {
                    nextW = nextW.right;
                }
                y.link(x);
                A[d] = null;
                ++d;
            }
            A[d] = x;
        } while ((w = nextW) != start);
        this.min = start;
        for (Node a : A) {
            if (a == null || !a.isLessThan((Node)this.min)) continue;
            this.min = a;
        }
    }

    public void decreaseKey(Node<T> x, float k) {
        this.decreaseKey(x, k, false);
    }

    private void decreaseKey(Node<T> x, float k, boolean delete) {
        if (!delete && k > ((Node)x).key) {
            throw new IllegalArgumentException("cannot increase key value");
        }
        ((Node)x).key = k;
        Node y = ((Node)x).parent;
        if (y != null && (delete || ((Node)x).isLessThan(y))) {
            y.cut(x, this.min);
            y.cascadingCut(this.min);
        }
        if (delete || ((Node)x).isLessThan((Node)this.min)) {
            this.min = x;
        }
    }

    public void delete(Node<T> x) {
        this.decreaseKey(x, 0.0f, true);
        this.removeMin();
    }

    public boolean isEmpty() {
        return this.min == null;
    }

    public Node<T> insert(T x, float key) {
        Node<T> node = new Node<T>(x, key);
        if (this.min != null) {
            ((Node)node).right = (Node)this.min;
            ((Node)node).left = ((Node)this.min).left;
            ((Node)this.min).left = (Node)node;
            ((Node)node).left.right = (Node)node;
            if (((Node)node).isLessThan((Node)this.min)) {
                this.min = node;
            }
        } else {
            this.min = node;
        }
        ++this.n;
        return node;
    }

    public Node<T> min() {
        return this.min;
    }

    public Node<T> removeMin() {
        Node<T> z = this.min;
        if (z == null) {
            return null;
        }
        if (((Node)z).child != null) {
            ((Node)z).child.parent = null;
            Node x = ((Node)z).child.right;
            while (x != ((Node)z).child) {
                x.parent = null;
                x = x.right;
            }
            Node minleft = ((Node)this.min).left;
            Node zchildleft = ((Node)z).child.left;
            ((Node)this.min).left = zchildleft;
            zchildleft.right = (Node)this.min;
            ((Node)z).child.left = minleft;
            minleft.right = ((Node)z).child;
        }
        ((Node)z).left.right = ((Node)z).right;
        ((Node)z).right.left = ((Node)z).left;
        if (z == ((Node)z).right) {
            this.min = null;
        } else {
            this.min = ((Node)z).right;
            this.consolidate();
        }
        --this.n;
        return z;
    }

    public int size() {
        return this.n;
    }

    public static <T extends Comparable<T>> FibonacciHeap<T> union(FibonacciHeap<T> H1, FibonacciHeap<T> H2) {
        FibonacciHeap<T> H = new FibonacciHeap<T>();
        if (H1 != null && H2 != null) {
            H.min = H1.min;
            if (H.min != null) {
                if (H2.min != null) {
                    ((Node)H.min).right.left = ((Node)H2.min).left;
                    ((Node)H2.min).left.right = ((Node)H.min).right;
                    ((Node)H.min).right = (Node)H2.min;
                    ((Node)H2.min).left = (Node)H.min;
                    if (((Node)H2.min).isLessThan((Node)H1.min)) {
                        H.min = H2.min;
                    }
                }
            } else {
                H.min = H2.min;
            }
            H.n = H1.n + H2.n;
        }
        return H;
    }

    public static class Node<T extends Comparable<T>> {
        private T datum;
        private float key;
        private Node<T> parent;
        private Node<T> child;
        private Node<T> right;
        private Node<T> left;
        private int degree;
        private boolean mark;

        public Node(T data, float key) {
            this.datum = data;
            this.key = key;
            this.right = this;
            this.left = this;
        }

        public void cascadingCut(Node<T> min) {
            Node<T> z = this.parent;
            if (z != null) {
                if (this.mark) {
                    z.cut(this, min);
                    z.cascadingCut(min);
                } else {
                    this.mark = true;
                }
            }
        }

        public void cut(Node<T> x, Node<T> min) {
            x.left.right = x.right;
            x.right.left = x.left;
            --this.degree;
            if (this.degree == 0) {
                this.child = null;
            } else if (this.child == x) {
                this.child = x.right;
            }
            x.right = min;
            x.left = min.left;
            min.left = x;
            x.left.right = x;
            x.parent = null;
            x.mark = false;
        }

        public void link(Node<T> parent) {
            this.left.right = this.right;
            this.right.left = this.left;
            this.parent = parent;
            if (parent.child == null) {
                parent.child = this;
                this.right = this;
                this.left = this;
            } else {
                this.left = parent.child;
                this.right = parent.child.right;
                parent.child.right = this;
                this.right.left = this;
            }
            ++parent.degree;
            this.mark = false;
        }

        public T getDatum() {
            return this.datum;
        }

        public float getKey() {
            return this.key;
        }

        private boolean isGreaterThan(Node<T> n) {
            return this.key > n.key || this.key == n.key && this.datum.compareTo(n.datum) > 0;
        }

        private boolean isLessThan(Node<T> n) {
            return this.key < n.key || this.key == n.key && this.datum.compareTo(n.datum) < 0;
        }
    }
}

