/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util;

public class FibonacciHeapInt {
    private Node min;
    private int n;

    public void clear() {
        this.min = null;
        this.n = 0;
    }

    private void consolidate() {
        Node nextW;
        Node[] A = new Node[45];
        Node start = this.min;
        Node w = this.min;
        do {
            Node x = w;
            nextW = w.right;
            int d = x.degree;
            while (A[d] != null) {
                Node y = A[d];
                if (x.isGreaterThan(y)) {
                    Node temp = y;
                    y = x;
                    x = temp;
                }
                if (y == start) {
                    start = start.right;
                }
                if (y == nextW) {
                    nextW = nextW.right;
                }
                y.link(x);
                A[d] = null;
                ++d;
            }
            A[d] = x;
        } while ((w = nextW) != start);
        this.min = start;
        for (Node a : A) {
            if (a == null || !a.isLessThan(this.min)) continue;
            this.min = a;
        }
    }

    public void decreaseKey(Node x, float k) {
        this.decreaseKey(x, k, false);
    }

    private void decreaseKey(Node x, float k, boolean delete) {
        if (!delete && k > x.key) {
            throw new IllegalArgumentException("cannot increase key value");
        }
        x.key = k;
        Node y = x.parent;
        if (y != null && (delete || x.isLessThan(y))) {
            y.cut(x, this.min);
            y.cascadingCut(this.min);
        }
        if (delete || x.isLessThan(this.min)) {
            this.min = x;
        }
    }

    public void delete(Node x) {
        this.decreaseKey(x, 0.0f, true);
        this.removeMin();
    }

    public boolean isEmpty() {
        return this.min == null;
    }

    public Node insert(int x, float key) {
        Node node = new Node(x, key);
        if (this.min != null) {
            node.right = this.min;
            node.left = this.min.left;
            this.min.left = node;
            node.left.right = node;
            if (node.isLessThan(this.min)) {
                this.min = node;
            }
        } else {
            this.min = node;
        }
        ++this.n;
        return node;
    }

    public Node min() {
        return this.min;
    }

    public Node removeMin() {
        Node z = this.min;
        if (z == null) {
            return null;
        }
        if (z.child != null) {
            z.child.parent = null;
            Node x = z.child.right;
            while (x != z.child) {
                x.parent = null;
                x = x.right;
            }
            Node minleft = this.min.left;
            Node zchildleft = z.child.left;
            this.min.left = zchildleft;
            zchildleft.right = this.min;
            z.child.left = minleft;
            minleft.right = z.child;
        }
        z.left.right = z.right;
        z.right.left = z.left;
        if (z == z.right) {
            this.min = null;
        } else {
            this.min = z.right;
            this.consolidate();
        }
        --this.n;
        return z;
    }

    public int size() {
        return this.n;
    }

    public static FibonacciHeapInt union(FibonacciHeapInt H1, FibonacciHeapInt H2) {
        FibonacciHeapInt H = new FibonacciHeapInt();
        if (H1 != null && H2 != null) {
            H.min = H1.min;
            if (H.min != null) {
                if (H2.min != null) {
                    H.min.right.left = H2.min.left;
                    H2.min.left.right = H.min.right;
                    H.min.right = H2.min;
                    H2.min.left = H.min;
                    if (H2.min.isLessThan(H1.min)) {
                        H.min = H2.min;
                    }
                }
            } else {
                H.min = H2.min;
            }
            H.n = H1.n + H2.n;
        }
        return H;
    }

    public static class Node {
        private int datum;
        private float key;
        private Node parent;
        private Node child;
        private Node right;
        private Node left;
        private int degree;
        private boolean mark;

        public Node(int data, float key) {
            this.datum = data;
            this.key = key;
            this.right = this;
            this.left = this;
        }

        public void cascadingCut(Node min) {
            Node z = this.parent;
            if (z != null) {
                if (this.mark) {
                    z.cut(this, min);
                    z.cascadingCut(min);
                } else {
                    this.mark = true;
                }
            }
        }

        public void cut(Node x, Node min) {
            x.left.right = x.right;
            x.right.left = x.left;
            --this.degree;
            if (this.degree == 0) {
                this.child = null;
            } else if (this.child == x) {
                this.child = x.right;
            }
            x.right = min;
            x.left = min.left;
            min.left = x;
            x.left.right = x;
            x.parent = null;
            x.mark = false;
        }

        public void link(Node parent) {
            this.left.right = this.right;
            this.right.left = this.left;
            this.parent = parent;
            if (parent.child == null) {
                parent.child = this;
                this.right = this;
                this.left = this;
            } else {
                this.left = parent.child;
                this.right = parent.child.right;
                parent.child.right = this;
                this.right.left = this;
            }
            ++parent.degree;
            this.mark = false;
        }

        public int getDatum() {
            return this.datum;
        }

        public float getKey() {
            return this.key;
        }

        private boolean isGreaterThan(Node n) {
            return this.key > n.key || this.key == n.key && this.datum > n.datum;
        }

        private boolean isLessThan(Node n) {
            return this.key < n.key || this.key == n.key && this.datum < n.datum;
        }
    }
}

