/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util;

import edu.umd.cloud9.util.FibonacciHeapInt;
import java.util.Hashtable;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FibonacciHeapIntTest
extends TestCase {
    public FibonacciHeapIntTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FibonacciHeapIntTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FibonacciHeapIntTest.suite());
    }

    public void test_Correctness() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
        Hashtable<Integer, FibonacciHeapInt.Node> entries = new Hashtable<Integer, FibonacciHeapInt.Node>();
        for (int ii = 100; ii < 200; ++ii) {
            Integer it = new Integer(ii);
            entries.put(it, heap.insert(it, ii));
        }
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)100, (int)heap.size());
        FibonacciHeapInt.Node entry = (FibonacciHeapInt.Node)entries.get(new Integer(110));
        heap.decreaseKey(entry, 50.0f);
        entry = (FibonacciHeapInt.Node)entries.get(new Integer(140));
        heap.decreaseKey(entry, 25.0f);
        entry = (FibonacciHeapInt.Node)entries.get(new Integer(160));
        heap.decreaseKey(entry, 15.0f);
        FibonacciHeapIntTest.assertEquals((Object)entry, (Object)heap.min());
        int o = heap.removeMin().getDatum();
        FibonacciHeapIntTest.assertEquals((int)160, (int)o);
        entry = (FibonacciHeapInt.Node)entries.get(new Integer(140));
        FibonacciHeapIntTest.assertEquals((Object)entry, (Object)heap.min());
        heap.delete(entry);
        entry = (FibonacciHeapInt.Node)entries.get(new Integer(110));
        heap.delete(entry);
        entry = (FibonacciHeapInt.Node)entries.get(new Integer(100));
        FibonacciHeapIntTest.assertEquals((Object)entry, (Object)heap.min());
        heap.clear();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
    }

    public void test_Duplicates() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
        float key = Float.MIN_NORMAL;
        for (int ii = 1; ii < 1001; ++ii) {
            Integer it = new Integer(ii);
            heap.insert(it, key);
        }
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)1000, (int)heap.size());
        FibonacciHeapInt.Node o = heap.removeMin();
        FibonacciHeapIntTest.assertTrue((boolean)(o instanceof FibonacciHeapInt.Node));
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)999, (int)heap.size());
        heap.clear();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
    }

    public void test_Duplicates_Larger() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
        float key = 0.0f;
        for (int ii = 1; ii < 1000; ++ii) {
            Integer it = new Integer(ii);
            heap.insert(it, key);
        }
        heap.insert(new Integer(1001), Float.MIN_NORMAL);
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)1000, (int)heap.size());
        FibonacciHeapInt.Node o = heap.removeMin();
        FibonacciHeapIntTest.assertTrue((boolean)(o instanceof FibonacciHeapInt.Node));
        FibonacciHeapIntTest.assertTrue((o.getDatum() < 1001 ? 1 : 0) != 0);
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)999, (int)heap.size());
        heap.clear();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
    }

    public void test_Duplicates_Smaller() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
        float key = Float.MIN_NORMAL;
        for (int ii = 1; ii < 1000; ++ii) {
            Integer it = new Integer(ii);
            heap.insert(it, key);
        }
        heap.insert(new Integer(1001), 0.0f);
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)1000, (int)heap.size());
        FibonacciHeapInt.Node o = heap.removeMin();
        FibonacciHeapIntTest.assertTrue((boolean)(o instanceof FibonacciHeapInt.Node));
        FibonacciHeapIntTest.assertTrue((o.getDatum() == 1001 ? 1 : 0) != 0);
        FibonacciHeapIntTest.assertFalse((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)999, (int)heap.size());
        heap.clear();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
    }

    public void test_InsertRemoveMin() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
        Random random = new Random();
        for (int ii = 1; ii <= 50000; ++ii) {
            float r = random.nextFloat();
            if (r < 0.0f) continue;
            heap.insert((int)r, r);
        }
        FibonacciHeapIntTest.assertEquals((int)50000, (int)heap.size());
        float ii = 0.0f;
        int count = 0;
        while (!heap.isEmpty()) {
            int v = heap.removeMin().getDatum();
            ++count;
            FibonacciHeapIntTest.assertTrue(((float)v >= ii ? 1 : 0) != 0);
            ii = v;
        }
        FibonacciHeapIntTest.assertEquals((int)50000, (int)count);
        FibonacciHeapIntTest.assertTrue((boolean)heap.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap.size());
    }

    public void test_Union() {
        FibonacciHeapInt heap1 = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap1.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap1.size());
        heap1.insert(new Integer(1), 1.0f);
        heap1.insert(new Integer(2), 2.0f);
        heap1.insert(new Integer(3), 3.0f);
        heap1.insert(new Integer(4), 4.0f);
        heap1.insert(new Integer(5), 5.0f);
        FibonacciHeapIntTest.assertFalse((boolean)heap1.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)5, (int)heap1.size());
        FibonacciHeapInt heap2 = new FibonacciHeapInt();
        FibonacciHeapIntTest.assertTrue((boolean)heap2.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)heap2.size());
        heap2.insert(new Integer(6), 6.0f);
        heap2.insert(new Integer(7), 7.0f);
        heap2.insert(new Integer(8), 8.0f);
        heap2.insert(new Integer(9), 9.0f);
        heap2.insert(new Integer(10), 10.0f);
        FibonacciHeapIntTest.assertFalse((boolean)heap2.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)5, (int)heap2.size());
        FibonacciHeapInt joined = FibonacciHeapInt.union(heap1, heap2);
        FibonacciHeapIntTest.assertFalse((boolean)joined.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)10, (int)joined.size());
        Integer v = joined.removeMin().getDatum();
        int vi = v;
        int ii = 1;
        FibonacciHeapIntTest.assertTrue((vi == ii ? 1 : 0) != 0);
        while (!joined.isEmpty()) {
            v = joined.removeMin().getDatum();
            vi = v;
            FibonacciHeapIntTest.assertTrue((vi > ii ? 1 : 0) != 0);
            ii = vi;
        }
        FibonacciHeapIntTest.assertTrue((boolean)joined.isEmpty());
        FibonacciHeapIntTest.assertEquals((int)0, (int)joined.size());
    }

    public void testBasic() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        heap.insert(1, 3.1f);
        heap.insert(2, 4.6f);
        heap.insert(3, 2.0f);
        heap.insert(4, 2.9f);
        FibonacciHeapIntTest.assertEquals((int)3, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)4, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)1, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)2, (int)heap.removeMin().getDatum());
    }

    public void testTies() {
        FibonacciHeapInt heap = new FibonacciHeapInt();
        heap.insert(1, 3.1f);
        heap.insert(2, 3.1f);
        heap.insert(3, 2.0f);
        heap.insert(4, 4.5f);
        heap.insert(5, 3.1f);
        heap.insert(6, 2.0f);
        FibonacciHeapIntTest.assertEquals((int)3, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)6, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)1, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)2, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)5, (int)heap.removeMin().getDatum());
        FibonacciHeapIntTest.assertEquals((int)4, (int)heap.removeMin().getDatum());
    }
}

