/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util;

import edu.umd.cloud9.io.pair.PairOfIntFloat;
import org.apache.hadoop.util.PriorityQueue;

public class TopNScoredInts {
    private final ScoredIntPriorityQueue queue;

    public TopNScoredInts(int n) {
        this.queue = new ScoredIntPriorityQueue(n);
    }

    public void add(int n, float f) {
        this.queue.insert(new PairOfIntFloat(n, f));
    }

    public PairOfIntFloat[] extractAll() {
        int len = this.queue.size();
        PairOfIntFloat[] arr = new PairOfIntFloat[len];
        for (int i = 0; i < len; ++i) {
            arr[len - 1 - i] = (PairOfIntFloat)this.queue.pop();
        }
        return arr;
    }

    private class ScoredIntPriorityQueue
    extends PriorityQueue<PairOfIntFloat> {
        private ScoredIntPriorityQueue(int maxSize) {
            super.initialize(maxSize);
        }

        protected boolean lessThan(Object obj0, Object obj1) {
            return ((PairOfIntFloat)obj0).getRightElement() < ((PairOfIntFloat)obj1).getRightElement();
        }
    }
}

