/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util;

import edu.umd.cloud9.util.pair.PairOfObjectFloat;
import org.apache.hadoop.util.PriorityQueue;

public class TopNScoredObjects<K extends Comparable<K>> {
    private final ScoredObjectPriorityQueue queue;

    public TopNScoredObjects(int n) {
        this.queue = new ScoredObjectPriorityQueue(n);
    }

    public void add(K obj, float f) {
        this.queue.insert(new PairOfObjectFloat<K>(obj, f));
    }

    public PairOfObjectFloat<K>[] extractAll() {
        int len = this.queue.size();
        PairOfObjectFloat[] arr = new PairOfObjectFloat[len];
        for (int i = 0; i < len; ++i) {
            arr[len - 1 - i] = (PairOfObjectFloat)this.queue.pop();
        }
        return arr;
    }

    private class ScoredObjectPriorityQueue
    extends PriorityQueue<PairOfObjectFloat<K>> {
        private ScoredObjectPriorityQueue(int maxSize) {
            super.initialize(maxSize);
        }

        protected boolean lessThan(Object obj0, Object obj1) {
            return ((PairOfObjectFloat)obj0).getRightElement() < ((PairOfObjectFloat)obj1).getRightElement();
        }
    }
}

