/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.array;

import edu.umd.cloud9.util.array.ArrayListOfShorts;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class ArrayListOfShortsTest {
    short neg_one = (short)-1;
    short zero = 0;
    short one = 1;
    short two = (short)2;
    short three = (short)3;
    short four = (short)4;
    short five = (short)5;
    short six = (short)6;
    short seven = (short)7;
    short nine = (short)9;

    @org.junit.Test
    public void testRemoveWithinBounds() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((this.one == a.remove(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.three == a.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.get(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.remove(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.seven == a.get(2) ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        a.remove(4);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds2() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add(this.neg_one);
        a.remove(-1);
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 10000;
        Random r = new Random();
        short[] shorts = new short[size];
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(size);
            list.add(k);
            shorts[i] = k;
        }
        for (i = 0; i < size; ++i) {
            short v = list.get(i);
            Assert.assertEquals((long)shorts[i], (long)v);
        }
    }

    @org.junit.Test
    public void testArrayConstructor() {
        short[] arr = new short[]{1, 2, 3, 4, 5};
        Assert.assertEquals((long)5L, (long)arr.length);
        ArrayListOfShorts list = new ArrayListOfShorts(arr);
        list.remove(2);
        Assert.assertEquals((long)1L, (long)arr[0]);
        Assert.assertEquals((long)2L, (long)arr[1]);
        Assert.assertEquals((long)3L, (long)arr[2]);
        Assert.assertEquals((long)4L, (long)arr[3]);
        Assert.assertEquals((long)5L, (long)arr[4]);
    }

    @org.junit.Test
    public void testRemove() {
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (int i = 0; i < 10; ++i) {
            list.add((short)i);
        }
        list.remove(list.indexOf((short)5));
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
        Assert.assertEquals((long)9L, (long)list.get(8));
        list.remove(list.indexOf((short)9));
        Assert.assertEquals((long)8L, (long)list.size);
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 10000;
        Random r = new Random();
        short[] shorts = new short[size];
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(size);
            list.add(k);
            shorts[i] = k;
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            list.set(i, (short)(shorts[i] + 1));
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            short v = list.get(i);
            Assert.assertEquals((long)(shorts[i] + 1), (long)v);
        }
    }

    @org.junit.Test
    public void testTrim1() {
        int i;
        int size = 89;
        Random r = new Random();
        short[] shorts = new short[size];
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(size);
            list.add(k);
            shorts[i] = k;
        }
        for (i = 0; i < size; ++i) {
            short v = list.get(i);
            Assert.assertEquals((long)shorts[i], (long)v);
        }
        short[] rawArray = list.getArray();
        int lenBefore = rawArray.length;
        list.trimToSize();
        short[] rawArrayAfter = list.getArray();
        int lenAfter = rawArrayAfter.length;
        Assert.assertEquals((long)89L, (long)lenAfter);
        Assert.assertTrue((lenBefore > lenAfter ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testClone() {
        int i;
        int size = 10000;
        Random r = new Random();
        int[] shorts = new int[size];
        ArrayListOfShorts list1 = new ArrayListOfShorts();
        for (int i2 = 0; i2 < size; ++i2) {
            short k = (short)r.nextInt(size);
            list1.add(k);
            shorts[i2] = k;
        }
        ArrayListOfShorts list2 = list1.clone();
        Assert.assertEquals((long)size, (long)list1.size());
        Assert.assertEquals((long)size, (long)list2.size());
        for (i = 0; i < size; ++i) {
            list2.set(i, (short)(shorts[i] + 1));
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)shorts[i], (long)list1.get(i));
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)(shorts[i] + 1), (long)list2.get(i));
        }
    }

    @org.junit.Test
    public void testToString1() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfShorts(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfShorts(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfShorts(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfShorts(1, 12).toString(11));
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfShorts().toString());
    }

    @org.junit.Test
    public void testToString2() {
        short v;
        int i;
        int size = 10;
        Random r = new Random();
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (int i2 = 0; i2 < size; ++i2) {
            list.add((short)r.nextInt(32768));
        }
        String out = list.toString();
        for (i = 0; i < size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Short(v).toString()) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < size; ++i) {
            list.add((short)r.nextInt(32768));
        }
        out = list.toString();
        for (i = size; i < size + size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Short(v).toString()) == -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((out.indexOf(size + " more") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIterable() {
        int i;
        int size = 1000;
        Random r = new Random();
        short[] shorts = new short[size];
        ArrayListOfShorts list = new ArrayListOfShorts();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(size);
            list.add(k);
            shorts[i] = k;
        }
        i = 0;
        for (Short v : list) {
            Assert.assertEquals((long)shorts[i++], (long)v.shortValue());
        }
    }

    @org.junit.Test
    public void testSetSize() {
        ArrayListOfShorts list = new ArrayListOfShorts();
        list.add((short)5);
        Assert.assertEquals((long)1L, (long)list.size);
        Assert.assertEquals((long)5L, (long)list.get(0));
        list.setSize(5);
        Assert.assertEquals((long)5L, (long)list.size);
        Assert.assertEquals((long)0L, (long)list.get(1));
        Assert.assertEquals((long)0L, (long)list.get(2));
        Assert.assertEquals((long)0L, (long)list.get(3));
        Assert.assertEquals((long)0L, (long)list.get(4));
        list.add((short)12);
        Assert.assertEquals((long)6L, (long)list.size);
        Assert.assertEquals((long)12L, (long)list.get(5));
    }

    @org.junit.Test
    public void testSort() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        Assert.assertEquals((long)0L, (long)a.size());
        a.add((short)5);
        a.add((short)6);
        a.add((short)1);
        a.add((short)4);
        Assert.assertEquals((long)4L, (long)a.size());
        a.sort();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((long)1L, (long)a.get(0));
        Assert.assertEquals((long)4L, (long)a.get(1));
        Assert.assertEquals((long)5L, (long)a.get(2));
        Assert.assertEquals((long)6L, (long)a.get(3));
    }

    @org.junit.Test
    public void testIntersection1() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)5);
        a.add((short)3);
        a.add((short)1);
        a.sort();
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)0);
        b.add((short)1);
        b.add((short)2);
        b.add((short)3);
        ArrayListOfShorts c = a.intersection(b);
        Assert.assertEquals((long)1L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)2L, (long)c.size());
    }

    @org.junit.Test
    public void testIntersection2() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)5);
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)0);
        b.add((short)1);
        b.add((short)2);
        b.add((short)3);
        ArrayListOfShorts c = a.intersection(b);
        Assert.assertTrue((c.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection3() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)3);
        a.add((short)5);
        a.add((short)7);
        a.add((short)8);
        a.add((short)9);
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)0);
        b.add((short)1);
        b.add((short)2);
        b.add((short)3);
        ArrayListOfShorts c = a.intersection(b);
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @org.junit.Test
    public void testIntersection4() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)3);
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)0);
        ArrayListOfShorts c = a.intersection(b);
        Assert.assertEquals((long)0L, (long)c.size());
    }

    @org.junit.Test
    public void testMerge1() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)3);
        a.add((short)7);
        a.add((short)10);
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)0);
        b.add((short)4);
        b.add((short)9);
        ArrayListOfShorts c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)0L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)4L, (long)c.get(2));
        Assert.assertEquals((long)7L, (long)c.get(3));
        Assert.assertEquals((long)9L, (long)c.get(4));
        Assert.assertEquals((long)10L, (long)c.get(5));
        ArrayListOfShorts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge2() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)3);
        a.add((short)7);
        a.add((short)10);
        ArrayListOfShorts b = new ArrayListOfShorts();
        b.add((short)11);
        b.add((short)19);
        b.add((short)21);
        ArrayListOfShorts c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)7L, (long)c.get(1));
        Assert.assertEquals((long)10L, (long)c.get(2));
        Assert.assertEquals((long)11L, (long)c.get(3));
        Assert.assertEquals((long)19L, (long)c.get(4));
        Assert.assertEquals((long)21L, (long)c.get(5));
        ArrayListOfShorts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge3() {
        ArrayListOfShorts a = new ArrayListOfShorts();
        a.add((short)3);
        a.add((short)7);
        a.add((short)10);
        ArrayListOfShorts b = new ArrayListOfShorts();
        ArrayListOfShorts c = a.merge(b);
        Assert.assertEquals((Object)c, (Object)a);
        ArrayListOfShorts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testSubList() {
        ArrayListOfShorts a = new ArrayListOfShorts(new short[]{1, 2, 3, 4, 5, 6, 7});
        ArrayListOfShorts b = a.subList(1, 5);
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
        a.clear();
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
    }

    @org.junit.Test
    public void testAddUnique() {
        ArrayListOfShorts a = new ArrayListOfShorts(new short[]{1, 2, 3, 4, 5, 6, 7});
        a.addUnique(new short[]{8, 0, 2, 5, -1, 11, 9});
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertEquals((long)0L, (long)a.get(8));
        Assert.assertEquals((long)-1L, (long)a.get(9));
        Assert.assertEquals((long)11L, (long)a.get(10));
        Assert.assertEquals((long)9L, (long)a.get(11));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfShortsTest.class);
    }
}

