/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.benchmark;

import edu.umd.cloud9.debug.MemoryUsageUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;

public class Benchmark1Object2IntOpenHashMap {
    public static void main(String[] args) {
        int i;
        int size = 5000000;
        Random r = new Random();
        int[] ints = new int[size];
        long usedMemory1 = MemoryUsageUtils.getUsedMemory();
        System.out.println("Benchmarking Object2IntOpenHashMap<String>...");
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        long startTime = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)("" + i), k);
            ints[i] = k;
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println(" Inserting " + size + " random entries: " + duration + " ms");
        startTime = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            int v = map.getInt((Object)("" + i));
            if (v == ints[i]) continue;
            throw new RuntimeException("Values don't match!");
        }
        duration = System.currentTimeMillis() - startTime;
        System.out.println(" Accessing " + size + " random entries: " + duration + " ms");
        long usedMemory2 = MemoryUsageUtils.getUsedMemory();
        System.out.println("Used memory before: " + usedMemory1);
        System.out.println("Used memory after: " + usedMemory2);
        System.out.println("Total memory usage: " + (usedMemory2 - usedMemory1));
        System.out.println("Memory usage per map entry: " + (float)(usedMemory2 - usedMemory1) / (float)size);
    }
}

