/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.benchmark;

import edu.umd.cloud9.util.map.HMapKI;
import edu.umd.cloud9.util.map.MapKI;
import java.util.Random;

public class BenchmarkRandomWalk2HMapKI {
    private static int removals = 0;

    public static void main(String[] args) {
        int size = 10000000;
        Random r = new Random();
        System.out.println("Benchmarking HMapKI<String>...");
        HMapKI<String> map = new HMapKI<String>();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            String k = "" + r.nextInt(1000);
            boolean increment = r.nextBoolean();
            if (increment) {
                BenchmarkRandomWalk2HMapKI.increment(map, k);
                continue;
            }
            BenchmarkRandomWalk2HMapKI.decrement(map, k);
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("removals: " + removals);
        System.out.println("Time taken: " + duration + " ms");
    }

    private static void increment(MapKI<String> map, String key) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + 1);
        } else {
            map.put(key, 1);
        }
    }

    private static void decrement(MapKI<String> map, String key) {
        if (map.containsKey(key)) {
            int val = map.get(key);
            if (val == 1) {
                ++removals;
                map.remove(key);
            } else {
                map.put(key, val - 1);
            }
        }
    }
}

