/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.benchmark;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;

public class BenchmarkRandomWalk2String2IntOpenHashMap {
    private static int removals = 0;

    public static void main(String[] args) {
        int size = 10000000;
        Random r = new Random();
        System.out.println("Benchmarking String2IntOpenHashMap...");
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            String k = "" + r.nextInt(1000);
            boolean increment = r.nextBoolean();
            if (increment) {
                BenchmarkRandomWalk2String2IntOpenHashMap.increment((Object2IntMap<String>)map, k);
                continue;
            }
            BenchmarkRandomWalk2String2IntOpenHashMap.decrement((Object2IntMap<String>)map, k);
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("removals: " + removals);
        System.out.println("Time taken: " + duration + " ms");
    }

    private static void increment(Object2IntMap<String> map, String key) {
        if (map.containsKey((Object)key)) {
            map.put((Object)key, (Integer)map.get((Object)key) + 1);
        } else {
            map.put((Object)key, 1);
        }
    }

    private static void decrement(Object2IntMap<String> map, String key) {
        if (map.containsKey((Object)key)) {
            int val = (Integer)map.get((Object)key);
            if (val == 1) {
                ++removals;
                map.remove((Object)key);
            } else {
                map.put((Object)key, val - 1);
            }
        }
    }
}

