/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.benchmark;

import com.google.common.collect.Lists;
import edu.umd.cloud9.debug.MemoryUsageUtils;
import edu.umd.cloud9.util.map.HMapIV;
import edu.umd.cloud9.util.map.MapIV;
import edu.umd.cloud9.util.map.TMapIV;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class BenchmarkTreeMap {
    private static final int NUM_TRIALS = 50000;
    private static final int NUM_FEATURES = 300;
    private static final boolean SAVE = false;
    private static final boolean SUM = true;
    private static final int KEY_RANGE = 1000000;
    private static final int VALUE_RANGE = 1000;
    private static final Random rand = new Random();

    public static void main(String[] args) {
        BenchmarkTreeMap.benchmarkTreeMap();
        BenchmarkTreeMap.benchmarkTMapIV();
        BenchmarkTreeMap.benchmarkHMapIV();
        BenchmarkTreeMap.benchmarkHMapIV();
        BenchmarkTreeMap.benchmarkTMapIV();
        BenchmarkTreeMap.benchmarkTreeMap();
    }

    private static void benchmarkTreeMap() {
        long startTime = System.currentTimeMillis();
        long usedMemory1 = MemoryUsageUtils.getUsedMemory();
        ArrayList lst = Lists.newArrayList();
        for (int i = 0; i < 50000; ++i) {
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            while (map.size() < 300) {
                map.put(rand.nextInt(1000000), rand.nextInt(1000) + "");
            }
            int sum = 0;
            for (Map.Entry entry : map.entrySet()) {
                sum += ((Integer)entry.getKey()).intValue();
            }
        }
        System.out.println(System.currentTimeMillis() - startTime);
        System.out.println(MemoryUsageUtils.getUsedMemory() - usedMemory1);
    }

    private static void benchmarkTMapIV() {
        long startTime = System.currentTimeMillis();
        long usedMemory1 = MemoryUsageUtils.getUsedMemory();
        ArrayList lst = Lists.newArrayList();
        for (int i = 0; i < 50000; ++i) {
            TMapIV<String> map = new TMapIV<String>();
            while (map.size() < 300) {
                map.put(rand.nextInt(1000000), rand.nextInt(1000) + "");
            }
            int sum = 0;
            for (MapIV.Entry entry : map.entrySet()) {
                sum += entry.getKey();
            }
        }
        System.out.println(System.currentTimeMillis() - startTime);
        System.out.println(MemoryUsageUtils.getUsedMemory() - usedMemory1);
    }

    private static void benchmarkHMapIV() {
        long startTime = System.currentTimeMillis();
        long usedMemory1 = MemoryUsageUtils.getUsedMemory();
        ArrayList lst = Lists.newArrayList();
        for (int i = 0; i < 50000; ++i) {
            HMapIV<String> map = new HMapIV<String>();
            while (map.size() < 300) {
                map.put(rand.nextInt(1000000), rand.nextInt(1000) + "");
            }
            ArrayList entries = Lists.newArrayList(map.entrySet());
            Collections.sort(entries, new Comparator<MapIV.Entry<String>>(){

                @Override
                public int compare(MapIV.Entry<String> o1, MapIV.Entry<String> o2) {
                    return o1.getKey() > o2.getKey() ? 1 : -1;
                }
            });
            int sum = 0;
            for (MapIV.Entry entry : entries) {
                sum += entry.getKey();
            }
        }
        System.out.println(System.currentTimeMillis() - startTime);
        System.out.println(MemoryUsageUtils.getUsedMemory() - usedMemory1);
    }
}

