/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.cfd;

import edu.umd.cloud9.util.cfd.Int2IntConditionalFrequencyDistribution;
import edu.umd.cloud9.util.cfd.Int2IntConditionalFrequencyDistributionEntry;
import edu.umd.cloud9.util.cfd.Int2IntConditionalFrequencyDistributionFastutil;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Int2IntConditionalFrequencyDistributionTest {
    @org.junit.Test
    public void test1Entry() {
        Int2IntConditionalFrequencyDistributionEntry cfd = new Int2IntConditionalFrequencyDistributionEntry();
        this.test1Common(cfd);
    }

    @org.junit.Test
    public void test1Fastutil() {
        Int2IntConditionalFrequencyDistributionFastutil cfd = new Int2IntConditionalFrequencyDistributionFastutil();
        this.test1Common(cfd);
    }

    private void test1Common(Int2IntConditionalFrequencyDistribution cfd) {
        cfd.set(1, 1, 2);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)2L, (long)cfd.getSumOfAllCounts());
        cfd.set(2, 1, 3);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)3L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)5L, (long)cfd.getSumOfAllCounts());
        cfd.set(3, 1, 10);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)3L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)10L, (long)cfd.get(3, 1));
        Assert.assertEquals((long)15L, (long)cfd.getSumOfAllCounts());
        cfd.set(10, 2, 1);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)3L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)10L, (long)cfd.get(3, 1));
        Assert.assertEquals((long)1L, (long)cfd.get(10, 2));
        Assert.assertEquals((long)16L, (long)cfd.getSumOfAllCounts());
        cfd.set(1, 1, 5);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)3L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)10L, (long)cfd.get(3, 1));
        Assert.assertEquals((long)1L, (long)cfd.get(10, 2));
        Assert.assertEquals((long)19L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void test2Entry() {
        Int2IntConditionalFrequencyDistributionEntry cfd = new Int2IntConditionalFrequencyDistributionEntry();
        this.test2Common(cfd);
    }

    @org.junit.Test
    public void test2Fastutil() {
        Int2IntConditionalFrequencyDistributionFastutil cfd = new Int2IntConditionalFrequencyDistributionFastutil();
        this.test2Common(cfd);
    }

    private void test2Common(Int2IntConditionalFrequencyDistribution cfd) {
        cfd.set(1, 1, 2);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)2L, (long)cfd.getSumOfAllCounts());
        cfd.increment(1, 1);
        cfd.check();
        Assert.assertEquals((long)3L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)3L, (long)cfd.getSumOfAllCounts());
        cfd.increment(1, 1, 2);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)5L, (long)cfd.getSumOfAllCounts());
        cfd.increment(2, 1);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)1L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)6L, (long)cfd.getSumOfAllCounts());
        cfd.increment(1, 2, 10);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get(1, 1));
        Assert.assertEquals((long)1L, (long)cfd.get(2, 1));
        Assert.assertEquals((long)10L, (long)cfd.get(1, 2));
        Assert.assertEquals((long)16L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void test3Entry() {
        Int2IntConditionalFrequencyDistributionEntry cfd = new Int2IntConditionalFrequencyDistributionEntry();
        this.test3Common(cfd);
    }

    @org.junit.Test
    public void test3Fastutil() {
        Int2IntConditionalFrequencyDistributionFastutil cfd = new Int2IntConditionalFrequencyDistributionFastutil();
        this.test3Common(cfd);
    }

    private void test3Common(Int2IntConditionalFrequencyDistribution cfd) {
        cfd.set(1, 1, 2);
        cfd.set(1, 2, 5);
        cfd.set(1, 3, 6);
        cfd.set(1, 4, 4);
        cfd.set(2, 1, 3);
        cfd.set(3, 1, 7);
        cfd.check();
        Assert.assertEquals((long)17L, (long)cfd.getMarginalCount(1));
        Assert.assertEquals((long)27L, (long)cfd.getSumOfAllCounts());
        cfd.increment(1, 1, 2);
        cfd.increment(2, 1);
        Assert.assertEquals((long)19L, (long)cfd.getMarginalCount(1));
        Assert.assertEquals((long)4L, (long)cfd.getMarginalCount(2));
        Assert.assertEquals((long)30L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void testLargeMarginalEntry() {
        Int2IntConditionalFrequencyDistributionEntry cfd = new Int2IntConditionalFrequencyDistributionEntry();
        this.testLargeMarginalCommon(cfd);
    }

    @org.junit.Test
    public void testLargeMarginalFastutil() {
        Int2IntConditionalFrequencyDistributionFastutil cfd = new Int2IntConditionalFrequencyDistributionFastutil();
        this.testLargeMarginalCommon(cfd);
    }

    private void testLargeMarginalCommon(Int2IntConditionalFrequencyDistribution cfd) {
        cfd.set(1, 2, 2000000000);
        cfd.set(1, 3, 2000000000);
        cfd.set(1, 5, 2000000000);
        cfd.set(1, 1, 2000000000);
        Assert.assertEquals((long)8000000000L, (long)cfd.getMarginalCount(1));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Int2IntConditionalFrequencyDistributionTest.class);
    }
}

