/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.cfd;

import edu.umd.cloud9.util.cfd.Object2IntConditionalFrequencyDistribution;
import edu.umd.cloud9.util.fd.Object2IntFrequencyDistribution;
import edu.umd.cloud9.util.fd.Object2IntFrequencyDistributionFastutil;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistribution;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistributionFastutil;
import edu.umd.cloud9.util.pair.PairOfObjectInt;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

public class Object2IntConditionalFrequencyDistributionFastutil<K extends Comparable<K>>
implements Object2IntConditionalFrequencyDistribution<K> {
    private final Object2ObjectMap<K, Object2IntFrequencyDistribution<K>> distributions = new Object2ObjectOpenHashMap();
    private final Object2LongFrequencyDistribution<K> marginals = new Object2LongFrequencyDistributionFastutil();
    private long sumOfAllCounts = 0L;

    @Override
    public void set(K k, K cond, int v) {
        if (!this.distributions.containsKey(cond)) {
            Object2IntFrequencyDistributionFastutil<K> fd = new Object2IntFrequencyDistributionFastutil<K>();
            fd.set(k, v);
            this.distributions.put(cond, fd);
            this.marginals.increment(k, v);
            this.sumOfAllCounts += (long)v;
        } else {
            Object2IntFrequencyDistribution fd = (Object2IntFrequencyDistribution)this.distributions.get(cond);
            int rv = fd.get(k);
            fd.set(k, v);
            this.distributions.put(cond, (Object)fd);
            this.marginals.increment(k, -rv + v);
            this.sumOfAllCounts = this.sumOfAllCounts - (long)rv + (long)v;
        }
    }

    @Override
    public void increment(K k, K cond) {
        this.increment(k, cond, 1);
    }

    @Override
    public void increment(K k, K cond, int v) {
        int cur = this.get(k, cond);
        if (cur == 0) {
            this.set(k, cond, v);
        } else {
            this.set(k, cond, cur + v);
        }
    }

    @Override
    public int get(K k, K cond) {
        if (!this.distributions.containsKey(cond)) {
            return 0;
        }
        return ((Object2IntFrequencyDistribution)this.distributions.get(cond)).get(k);
    }

    @Override
    public long getMarginalCount(K k) {
        return this.marginals.get(k);
    }

    @Override
    public Object2IntFrequencyDistribution<K> getConditionalDistribution(K cond) {
        if (this.distributions.containsKey(cond)) {
            return (Object2IntFrequencyDistribution)this.distributions.get(cond);
        }
        return new Object2IntFrequencyDistributionFastutil();
    }

    @Override
    public long getSumOfAllCounts() {
        return this.sumOfAllCounts;
    }

    @Override
    public void check() {
        Object2IntFrequencyDistributionFastutil<Object> m = new Object2IntFrequencyDistributionFastutil<Object>();
        long totalSum = 0L;
        for (Object2IntFrequencyDistribution fd : this.distributions.values()) {
            long conditionalSum = 0L;
            for (PairOfObjectInt pair : fd) {
                conditionalSum += (long)pair.getRightElement();
                m.increment(pair.getLeftElement(), pair.getRightElement());
            }
            if (conditionalSum != fd.getSumOfCounts()) {
                throw new RuntimeException("Internal Error!");
            }
            totalSum += fd.getSumOfCounts();
        }
        if (totalSum != this.getSumOfAllCounts()) {
            throw new RuntimeException("Internal Error! Got " + totalSum + ", Expected " + this.getSumOfAllCounts());
        }
        for (PairOfObjectInt e : m) {
            if ((long)e.getRightElement() == this.marginals.get(e.getLeftElement())) continue;
            throw new RuntimeException("Internal Error!");
        }
        for (PairOfObjectInt e : m) {
            if (e.getRightElement() == m.get(e.getLeftElement())) continue;
            throw new RuntimeException("Internal Error!");
        }
    }
}

