/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.cfd;

import edu.umd.cloud9.util.cfd.Object2IntConditionalFrequencyDistribution;
import edu.umd.cloud9.util.cfd.Object2IntConditionalFrequencyDistributionEntry;
import edu.umd.cloud9.util.cfd.Object2IntConditionalFrequencyDistributionFastutil;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Object2IntConditionalFrequencyDistributionTest {
    @org.junit.Test
    public void test1Entry() {
        Object2IntConditionalFrequencyDistributionEntry<String> cfd = new Object2IntConditionalFrequencyDistributionEntry<String>();
        this.test1Common(cfd);
    }

    @org.junit.Test
    public void test1Fastutil() {
        Object2IntConditionalFrequencyDistributionFastutil<String> cfd = new Object2IntConditionalFrequencyDistributionFastutil<String>();
        this.test1Common(cfd);
    }

    private void test1Common(Object2IntConditionalFrequencyDistribution<String> cfd) {
        cfd.set("a", "a", 2);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)2L, (long)cfd.getSumOfAllCounts());
        cfd.set("b", "a", 3);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)3L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)5L, (long)cfd.getSumOfAllCounts());
        cfd.set("c", "a", 10);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)3L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)10L, (long)cfd.get("c", "a"));
        Assert.assertEquals((long)15L, (long)cfd.getSumOfAllCounts());
        cfd.set("x", "b", 1);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)3L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)10L, (long)cfd.get("c", "a"));
        Assert.assertEquals((long)1L, (long)cfd.get("x", "b"));
        Assert.assertEquals((long)16L, (long)cfd.getSumOfAllCounts());
        cfd.set("a", "a", 5);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)3L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)10L, (long)cfd.get("c", "a"));
        Assert.assertEquals((long)1L, (long)cfd.get("x", "b"));
        Assert.assertEquals((long)19L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void test2Entry() {
        Object2IntConditionalFrequencyDistributionEntry<String> cfd = new Object2IntConditionalFrequencyDistributionEntry<String>();
        this.test2Common(cfd);
    }

    @org.junit.Test
    public void test2Fastutil() {
        Object2IntConditionalFrequencyDistributionFastutil<String> cfd = new Object2IntConditionalFrequencyDistributionFastutil<String>();
        this.test2Common(cfd);
    }

    private void test2Common(Object2IntConditionalFrequencyDistribution<String> cfd) {
        cfd.set("a", "a", 2);
        cfd.check();
        Assert.assertEquals((long)2L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)2L, (long)cfd.getSumOfAllCounts());
        cfd.increment("a", "a");
        cfd.check();
        Assert.assertEquals((long)3L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)3L, (long)cfd.getSumOfAllCounts());
        cfd.increment("a", "a", 2);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)5L, (long)cfd.getSumOfAllCounts());
        cfd.increment("b", "a");
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)1L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)6L, (long)cfd.getSumOfAllCounts());
        cfd.increment("a", "b", 10);
        cfd.check();
        Assert.assertEquals((long)5L, (long)cfd.get("a", "a"));
        Assert.assertEquals((long)1L, (long)cfd.get("b", "a"));
        Assert.assertEquals((long)10L, (long)cfd.get("a", "b"));
        Assert.assertEquals((long)16L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void test3Entry() {
        Object2IntConditionalFrequencyDistributionEntry<String> cfd = new Object2IntConditionalFrequencyDistributionEntry<String>();
        this.test3Common(cfd);
    }

    @org.junit.Test
    public void test3Fastutil() {
        Object2IntConditionalFrequencyDistributionFastutil<String> cfd = new Object2IntConditionalFrequencyDistributionFastutil<String>();
        this.test3Common(cfd);
    }

    private void test3Common(Object2IntConditionalFrequencyDistribution<String> cfd) {
        cfd.set("a", "a", 2);
        cfd.set("a", "b", 5);
        cfd.set("a", "c", 6);
        cfd.set("a", "d", 4);
        cfd.set("b", "a", 3);
        cfd.set("c", "a", 7);
        cfd.check();
        Assert.assertEquals((long)17L, (long)cfd.getMarginalCount("a"));
        Assert.assertEquals((long)27L, (long)cfd.getSumOfAllCounts());
        cfd.increment("a", "a", 2);
        cfd.increment("b", "a");
        Assert.assertEquals((long)19L, (long)cfd.getMarginalCount("a"));
        Assert.assertEquals((long)4L, (long)cfd.getMarginalCount("b"));
        Assert.assertEquals((long)30L, (long)cfd.getSumOfAllCounts());
    }

    @org.junit.Test
    public void testLargeMarginalEntry() {
        Object2IntConditionalFrequencyDistributionEntry<String> cfd = new Object2IntConditionalFrequencyDistributionEntry<String>();
        this.testLargeMarginalCommon(cfd);
    }

    @org.junit.Test
    public void testLargeMarginalFastutil() {
        Object2IntConditionalFrequencyDistributionFastutil<String> cfd = new Object2IntConditionalFrequencyDistributionFastutil<String>();
        this.testLargeMarginalCommon(cfd);
    }

    private void testLargeMarginalCommon(Object2IntConditionalFrequencyDistribution<String> cfd) {
        cfd.set("1", "2", 2000000000);
        cfd.set("1", "3", 2000000000);
        cfd.set("1", "5", 2000000000);
        cfd.set("1", "1", 2000000000);
        Assert.assertEquals((long)8000000000L, (long)cfd.getMarginalCount("1"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Object2IntConditionalFrequencyDistributionTest.class);
    }
}

