/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.fd;

import com.google.common.collect.Lists;
import edu.umd.cloud9.io.pair.PairOfInts;
import edu.umd.cloud9.util.SortableEntries;
import edu.umd.cloud9.util.fd.Int2IntFrequencyDistribution;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Int2IntFrequencyDistributionFastutil
implements Int2IntFrequencyDistribution {
    private Int2IntOpenHashMap counts = new Int2IntOpenHashMap();
    private long sumOfCounts = 0L;
    private final Comparator<PairOfInts> comparatorRightDescending = new Comparator<PairOfInts>(){

        @Override
        public int compare(PairOfInts e1, PairOfInts e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return -1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return 1;
            }
            if (e1.getLeftElement() == e2.getLeftElement()) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement() < e2.getLeftElement() ? -1 : 1;
        }
    };
    private final Comparator<PairOfInts> comparatorRightAscending = new Comparator<PairOfInts>(){

        @Override
        public int compare(PairOfInts e1, PairOfInts e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return 1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return -1;
            }
            if (e1.getLeftElement() == e2.getLeftElement()) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement() < e2.getLeftElement() ? -1 : 1;
        }
    };
    private final Comparator<PairOfInts> comparatorLeftAscending = new Comparator<PairOfInts>(){

        @Override
        public int compare(PairOfInts e1, PairOfInts e2) {
            if (e1.getLeftElement() > e2.getLeftElement()) {
                return 1;
            }
            if (e1.getLeftElement() < e2.getLeftElement()) {
                return -1;
            }
            throw new RuntimeException("Event observed twice!");
        }
    };
    private final Comparator<PairOfInts> comparatorLeftDescending = new Comparator<PairOfInts>(){

        @Override
        public int compare(PairOfInts e1, PairOfInts e2) {
            if (e1.getLeftElement() > e2.getLeftElement()) {
                return -1;
            }
            if (e1.getLeftElement() < e2.getLeftElement()) {
                return 1;
            }
            throw new RuntimeException("Event observed twice!");
        }
    };

    @Override
    public void increment(int key) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + 1);
        } else {
            this.set(key, 1);
        }
    }

    @Override
    public void increment(int key, int cnt) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + cnt);
        } else {
            this.set(key, cnt);
        }
    }

    @Override
    public void decrement(int key) {
        if (this.contains(key)) {
            int v = this.get(key);
            if (v == 1) {
                this.remove(key);
            } else {
                this.set(key, v - 1);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public void decrement(int key, int cnt) {
        if (this.contains(key)) {
            int v = this.get(key);
            if (v < cnt) {
                throw new RuntimeException("Can't decrement past zero!");
            }
            if (v == cnt) {
                this.remove(key);
            } else {
                this.set(key, v - cnt);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public boolean contains(int key) {
        return this.counts.containsKey(key);
    }

    @Override
    public int get(int key) {
        return this.counts.get(key);
    }

    @Override
    public double computeRelativeFrequency(int k) {
        return (double)this.counts.get(k) / (double)this.getSumOfCounts();
    }

    @Override
    public double computeLogRelativeFrequency(int k) {
        return Math.log(this.counts.get(k)) - Math.log(this.getSumOfCounts());
    }

    @Override
    public int set(int key, int cnt) {
        int rv = this.counts.put(key, cnt);
        this.sumOfCounts = this.sumOfCounts - (long)rv + (long)cnt;
        return rv;
    }

    @Override
    public int remove(int key) {
        int rv = this.counts.remove(key);
        this.sumOfCounts -= (long)rv;
        return rv;
    }

    @Override
    public void clear() {
        this.counts.clear();
        this.sumOfCounts = 0L;
    }

    public IntSet keySet() {
        return this.counts.keySet();
    }

    public IntCollection values() {
        return this.counts.values();
    }

    public Int2IntMap.FastEntrySet entrySet() {
        return this.counts.int2IntEntrySet();
    }

    @Override
    public int getNumberOfEvents() {
        return this.counts.size();
    }

    @Override
    public long getSumOfCounts() {
        return this.sumOfCounts;
    }

    @Override
    public Iterator<PairOfInts> iterator() {
        return new Iterator<PairOfInts>(){
            private Iterator<Int2IntMap.Entry> iter;
            private final PairOfInts pair;
            {
                this.iter = Int2IntFrequencyDistributionFastutil.this.counts.int2IntEntrySet().iterator();
                this.pair = new PairOfInts();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public PairOfInts next() {
                if (!this.hasNext()) {
                    return null;
                }
                Int2IntMap.Entry entry = this.iter.next();
                this.pair.set(entry.getIntKey(), entry.getIntValue());
                return this.pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<PairOfInts> getEntries(SortableEntries.Order ordering) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending);
        }
        return null;
    }

    @Override
    public List<PairOfInts> getEntries(SortableEntries.Order ordering, int n) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending, n);
        }
        return null;
    }

    private List<PairOfInts> getEntriesSorted(Comparator<PairOfInts> comparator) {
        ArrayList list = Lists.newArrayList();
        for (Int2IntMap.Entry e : this.counts.int2IntEntrySet()) {
            list.add(new PairOfInts(e.getIntKey(), e.getIntValue()));
        }
        Collections.sort(list, comparator);
        return list;
    }

    private List<PairOfInts> getEntriesSorted(Comparator<PairOfInts> comparator, int n) {
        List<PairOfInts> list = this.getEntriesSorted(comparator);
        return list.subList(0, n);
    }
}

