/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.fd;

import edu.umd.cloud9.util.SortableEntries;
import edu.umd.cloud9.util.fd.Object2IntFrequencyDistribution;
import edu.umd.cloud9.util.fd.Object2IntFrequencyDistributionEntry;
import edu.umd.cloud9.util.fd.Object2IntFrequencyDistributionFastutil;
import edu.umd.cloud9.util.pair.PairOfObjectInt;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Object2IntFrequencyDistributionTest {
    @org.junit.Test
    public void test1Entry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.test1Common(fd);
    }

    @org.junit.Test
    public void test1Fastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.test1Common(fd);
    }

    private void test1Common(Object2IntFrequencyDistribution<String> fd) {
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        fd.increment("b");
        fd.increment("c");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)3L, (long)fd.get("c"));
        Assert.assertEquals((double)0.16666666666666666, (double)fd.computeRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333333333333, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.16666666666666666), (double)fd.computeLogRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333333333333), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        fd.decrement("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)2L, (long)fd.get("c"));
        Assert.assertEquals((double)0.2, (double)fd.computeRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2), (double)fd.computeLogRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        fd.decrement("a");
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)2L, (long)fd.get("c"));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        Set<String> set = fd.keySet();
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertFalse((boolean)set.contains("a"));
        Assert.assertTrue((boolean)set.contains("b"));
        Assert.assertTrue((boolean)set.contains("c"));
    }

    @org.junit.Test
    public void test2Entry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.test2Common(fd);
    }

    @org.junit.Test
    public void test2Fastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.test2Common(fd);
    }

    private void test2Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment("a");
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        fd.set("d", 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.set("a", 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.increment("c");
        fd.increment("c");
        fd.increment("c");
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.set("c", 1);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
    }

    @org.junit.Test
    public void test3Entry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.test3Common(fd);
    }

    @org.junit.Test
    public void test3Fastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.test3Common(fd);
    }

    private void test3Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment("a");
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement1Entry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testFailedDecrement1Common(fd);
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement1Fastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testFailedDecrement1Common(fd);
    }

    private void testFailedDecrement1Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment("a");
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        fd.decrement("a");
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.decrement("a");
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement2Entry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testFailedDecrement2Common(fd);
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement2Fastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testFailedDecrement2Common(fd);
    }

    private void testFailedDecrement2Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment("a", 1000);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get("a"));
        fd.decrement("a", 997);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get("a"));
        fd.decrement("a", 3);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.increment("a", 3);
        fd.decrement("a", 4);
    }

    @org.junit.Test
    public void testMultiIncrementDecrementEntry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testMultiIncrementDecrementCommon(fd);
    }

    @org.junit.Test
    public void testMultiIncrementDecrementFastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testMultiIncrementDecrementCommon(fd);
    }

    private void testMultiIncrementDecrementCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.increment("a", 2);
        fd.increment("b", 3);
        fd.increment("c", 4);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)3L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
        fd.decrement("b", 2);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
    }

    @org.junit.Test
    public void testGetFrequencySortedEntry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testGetFrequencySortedCommon(fd);
    }

    @org.junit.Test
    public void testGetFrequencySortedFastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testGetFrequencySortedCommon(fd);
    }

    private void testGetFrequencySortedCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set("a", 5);
        fd.set("d", 2);
        fd.set("b", 5);
        fd.set("e", 2);
        fd.set("f", 1);
        fd.set("c", 5);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
    }

    @org.junit.Test
    public void testGetSortedEventsEntry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testGetSortedEventsCommon(fd);
    }

    @org.junit.Test
    public void testGetSortedEventsFastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testGetSortedEventsCommon(fd);
    }

    private void testGetSortedEventsCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set("a", 1);
        fd.set("d", 3);
        fd.set("b", 4);
        fd.set("e", 7);
        fd.set("f", 9);
        fd.set("c", 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
    }

    @org.junit.Test
    public void testIterableEntry() {
        Object2IntFrequencyDistributionEntry<String> fd = new Object2IntFrequencyDistributionEntry<String>();
        this.testIterableCommon(fd);
    }

    @org.junit.Test
    public void testIterableFastutil() {
        Object2IntFrequencyDistributionFastutil<String> fd = new Object2IntFrequencyDistributionFastutil<String>();
        this.testIterableCommon(fd);
    }

    private void testIterableCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set("a", 1);
        fd.set("d", 3);
        fd.set("b", 4);
        fd.set("e", 7);
        fd.set("f", 9);
        fd.set("c", 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<Object> list = new TreeSet<Object>();
        for (PairOfObjectInt pairOfObjectInt : fd) {
            list.add(pairOfObjectInt.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfObjectInt pairOfObjectInt = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"a", pairOfObjectInt.getLeftElement());
        Assert.assertEquals((long)1L, (long)pairOfObjectInt.getRightElement());
        PairOfObjectInt pairOfObjectInt2 = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"b", pairOfObjectInt2.getLeftElement());
        Assert.assertEquals((long)4L, (long)pairOfObjectInt2.getRightElement());
        PairOfObjectInt pairOfObjectInt3 = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"c", pairOfObjectInt3.getLeftElement());
        Assert.assertEquals((long)2L, (long)pairOfObjectInt3.getRightElement());
        PairOfObjectInt pairOfObjectInt4 = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"d", pairOfObjectInt4.getLeftElement());
        Assert.assertEquals((long)3L, (long)pairOfObjectInt4.getRightElement());
        PairOfObjectInt pairOfObjectInt5 = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"e", pairOfObjectInt5.getLeftElement());
        Assert.assertEquals((long)7L, (long)pairOfObjectInt5.getRightElement());
        PairOfObjectInt pairOfObjectInt6 = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"f", pairOfObjectInt6.getLeftElement());
        Assert.assertEquals((long)9L, (long)pairOfObjectInt6.getRightElement());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Object2IntFrequencyDistributionTest.class);
    }
}

