/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.fd;

import com.google.common.collect.Lists;
import edu.umd.cloud9.util.SortableEntries;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistribution;
import edu.umd.cloud9.util.pair.PairOfObjectLong;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Object2LongFrequencyDistributionFastutil<K extends Comparable<K>>
implements Object2LongFrequencyDistribution<K> {
    private Object2LongOpenHashMap<K> counts = new Object2LongOpenHashMap();
    private long sumOfCounts = 0L;
    private final Comparator<PairOfObjectLong<K>> comparatorRightDescending = new Comparator<PairOfObjectLong<K>>(){

        @Override
        public int compare(PairOfObjectLong<K> e1, PairOfObjectLong<K> e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return -1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return 1;
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectLong<K>> comparatorRightAscending = new Comparator<PairOfObjectLong<K>>(){

        @Override
        public int compare(PairOfObjectLong<K> e1, PairOfObjectLong<K> e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return 1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return -1;
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectLong<K>> comparatorLeftAscending = new Comparator<PairOfObjectLong<K>>(){

        @Override
        public int compare(PairOfObjectLong<K> e1, PairOfObjectLong<K> e2) {
            if (e1.getLeftElement().equals(e2.getLeftElement())) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectLong<K>> comparatorLeftDescending = new Comparator<PairOfObjectLong<K>>(){

        @Override
        public int compare(PairOfObjectLong<K> e1, PairOfObjectLong<K> e2) {
            if (e1.getLeftElement().equals(e2.getLeftElement())) {
                throw new RuntimeException("Event observed twice!");
            }
            return e2.getLeftElement().compareTo(e1.getLeftElement());
        }
    };

    @Override
    public void increment(K key) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + 1L);
        } else {
            this.set(key, 1L);
        }
    }

    @Override
    public void increment(K key, long cnt) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + cnt);
        } else {
            this.set(key, cnt);
        }
    }

    @Override
    public void decrement(K key) {
        if (this.contains(key)) {
            long v = this.get(key);
            if (v == 1L) {
                this.remove(key);
            } else {
                this.set(key, v - 1L);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public void decrement(K key, long cnt) {
        if (this.contains(key)) {
            long v = this.get(key);
            if (v < cnt) {
                throw new RuntimeException("Can't decrement past zero!");
            }
            if (v == cnt) {
                this.remove(key);
            } else {
                this.set(key, v - cnt);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public boolean contains(K key) {
        return this.counts.containsKey(key);
    }

    @Override
    public long get(K key) {
        return this.counts.getLong(key);
    }

    @Override
    public double computeRelativeFrequency(K k) {
        return (double)this.counts.get(k).longValue() / (double)this.getSumOfCounts();
    }

    @Override
    public double computeLogRelativeFrequency(K k) {
        return Math.log(this.counts.get(k).longValue()) - Math.log(this.getSumOfCounts());
    }

    @Override
    public long set(K k, long v) {
        long rv = this.counts.put(k, v);
        this.sumOfCounts = this.sumOfCounts - rv + v;
        return rv;
    }

    @Override
    public long remove(K k) {
        long rv = this.counts.remove(k);
        this.sumOfCounts -= rv;
        return rv;
    }

    @Override
    public void clear() {
        this.counts.clear();
        this.sumOfCounts = 0L;
    }

    public LongCollection values() {
        return this.counts.values();
    }

    public Object2LongMap.FastEntrySet<K> entrySet() {
        return this.counts.object2LongEntrySet();
    }

    @Override
    public int getNumberOfEvents() {
        return this.counts.size();
    }

    @Override
    public long getSumOfCounts() {
        return this.sumOfCounts;
    }

    @Override
    public Set<K> keySet() {
        return this.counts.keySet();
    }

    @Override
    public Iterator<PairOfObjectLong<K>> iterator() {
        return new Iterator<PairOfObjectLong<K>>(){
            private Iterator<Object2LongMap.Entry<K>> iter;
            private final PairOfObjectLong<K> pair;
            {
                this.iter = Object2LongFrequencyDistributionFastutil.this.counts.object2LongEntrySet().iterator();
                this.pair = new PairOfObjectLong();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public PairOfObjectLong<K> next() {
                if (!this.hasNext()) {
                    return null;
                }
                Object2LongMap.Entry entry = this.iter.next();
                this.pair.set((Comparable)entry.getKey(), entry.getLongValue());
                return this.pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<PairOfObjectLong<K>> getEntries(SortableEntries.Order ordering) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending);
        }
        return null;
    }

    @Override
    public List<PairOfObjectLong<K>> getEntries(SortableEntries.Order ordering, int n) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending, n);
        }
        return null;
    }

    private List<PairOfObjectLong<K>> getEntriesSorted(Comparator<PairOfObjectLong<K>> comparator) {
        ArrayList list = Lists.newArrayList();
        for (Object2LongMap.Entry e : this.counts.object2LongEntrySet()) {
            list.add(new PairOfObjectLong<Comparable>((Comparable)e.getKey(), e.getLongValue()));
        }
        Collections.sort(list, comparator);
        return list;
    }

    private List<PairOfObjectLong<K>> getEntriesSorted(Comparator<PairOfObjectLong<K>> comparator, int n) {
        List<PairOfObjectLong<K>> list = this.getEntriesSorted(comparator);
        return list.subList(0, n);
    }
}

