/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.fd;

import edu.umd.cloud9.util.SortableEntries;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistribution;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistributionEntry;
import edu.umd.cloud9.util.fd.Object2LongFrequencyDistributionFastutil;
import edu.umd.cloud9.util.pair.PairOfObjectLong;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Object2LongFrequencyDistributionTest {
    @org.junit.Test
    public void test1Entry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.test1Common(fd);
    }

    @org.junit.Test
    public void test1Fastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.test1Common(fd);
    }

    private void test1Common(Object2LongFrequencyDistribution<String> fd) {
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        fd.increment("b");
        fd.increment("c");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)3L, (long)fd.get("c"));
        Assert.assertEquals((double)0.16666666666666666, (double)fd.computeRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333333333333, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.16666666666666666), (double)fd.computeLogRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333333333333), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        fd.decrement("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)2L, (long)fd.get("c"));
        Assert.assertEquals((double)0.2, (double)fd.computeRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2), (double)fd.computeLogRelativeFrequency("a"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        fd.decrement("a");
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        Assert.assertEquals((long)2L, (long)fd.get("b"));
        Assert.assertEquals((long)2L, (long)fd.get("c"));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency("c"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("b"), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency("c"), (double)1.0E-5);
        Set<String> set = fd.keySet();
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertFalse((boolean)set.contains("a"));
        Assert.assertTrue((boolean)set.contains("b"));
        Assert.assertTrue((boolean)set.contains("c"));
    }

    @org.junit.Test
    public void test2Entry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.test2Common(fd);
    }

    @org.junit.Test
    public void test2Fastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.test2Common(fd);
    }

    private void test2Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment("a");
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        fd.set("d", 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.set("a", 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.increment("c");
        fd.increment("c");
        fd.increment("c");
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
        fd.set("c", 1L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        Assert.assertEquals((long)5L, (long)fd.get("d"));
    }

    @org.junit.Test
    public void test3Entry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.test3Common(fd);
    }

    @org.junit.Test
    public void test3Fastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.test3Common(fd);
    }

    private void test3Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment("a");
        fd.increment("a");
        fd.increment("b");
        fd.increment("c");
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)1L, (long)fd.get("c"));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement1Entry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testFailedDecrement1Common(fd);
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement1Fastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testFailedDecrement1Common(fd);
    }

    private void testFailedDecrement1Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment("a");
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get("a"));
        fd.decrement("a");
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.decrement("a");
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement2Entry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testFailedDecrement2Common(fd);
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testFailedDecrement2Fastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testFailedDecrement2Common(fd);
    }

    private void testFailedDecrement2Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment("a", 1000L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get("a"));
        fd.decrement("a", 997L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get("a"));
        fd.decrement("a", 3L);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get("a"));
        fd.increment("a", 3L);
        fd.decrement("a", 4L);
    }

    @org.junit.Test
    public void testMultiIncrementDecrementEntry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testMultiIncrementDecrementCommon(fd);
    }

    @org.junit.Test
    public void testMultiIncrementDecrementFastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testMultiIncrementDecrementCommon(fd);
    }

    private void testMultiIncrementDecrementCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.increment("a", 2L);
        fd.increment("b", 3L);
        fd.increment("c", 4L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)3L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
        fd.decrement("b", 2L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get("a"));
        Assert.assertEquals((long)1L, (long)fd.get("b"));
        Assert.assertEquals((long)4L, (long)fd.get("c"));
    }

    @org.junit.Test
    public void testGetFrequencySortedEntry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testGetFrequencySortedCommon(fd);
    }

    @org.junit.Test
    public void testGetFrequencySortedFastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testGetFrequencySortedCommon(fd);
    }

    private void testGetFrequencySortedCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set("a", 5L);
        fd.set("d", 2L);
        fd.set("b", 5L);
        fd.set("e", 2L);
        fd.set("f", 1L);
        fd.set("c", 5L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
    }

    @org.junit.Test
    public void testGetSortedEventsEntry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testGetSortedEventsCommon(fd);
    }

    @org.junit.Test
    public void testGetSortedEventsFastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testGetSortedEventsCommon(fd);
    }

    private void testGetSortedEventsCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set("a", 1L);
        fd.set("d", 3L);
        fd.set("b", 4L);
        fd.set("e", 7L);
        fd.set("f", 9L);
        fd.set("c", 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", ((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", ((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", ((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", ((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
    }

    @org.junit.Test
    public void testIterableEntry() {
        Object2LongFrequencyDistributionEntry<String> fd = new Object2LongFrequencyDistributionEntry<String>();
        this.testIterableCommon(fd);
    }

    @org.junit.Test
    public void testIterableFastutil() {
        Object2LongFrequencyDistributionFastutil<String> fd = new Object2LongFrequencyDistributionFastutil<String>();
        this.testIterableCommon(fd);
    }

    private void testIterableCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set("a", 1L);
        fd.set("d", 3L);
        fd.set("b", 4L);
        fd.set("e", 7L);
        fd.set("f", 9L);
        fd.set("c", 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<Object> list = new TreeSet<Object>();
        for (PairOfObjectLong pairOfObjectLong : fd) {
            list.add(pairOfObjectLong.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfObjectLong pairOfObjectLong = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"a", pairOfObjectLong.getLeftElement());
        Assert.assertEquals((long)1L, (long)pairOfObjectLong.getRightElement());
        PairOfObjectLong pairOfObjectLong2 = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"b", pairOfObjectLong2.getLeftElement());
        Assert.assertEquals((long)4L, (long)pairOfObjectLong2.getRightElement());
        PairOfObjectLong pairOfObjectLong3 = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"c", pairOfObjectLong3.getLeftElement());
        Assert.assertEquals((long)2L, (long)pairOfObjectLong3.getRightElement());
        PairOfObjectLong pairOfObjectLong4 = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"d", pairOfObjectLong4.getLeftElement());
        Assert.assertEquals((long)3L, (long)pairOfObjectLong4.getRightElement());
        PairOfObjectLong pairOfObjectLong5 = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"e", pairOfObjectLong5.getLeftElement());
        Assert.assertEquals((long)7L, (long)pairOfObjectLong5.getRightElement());
        PairOfObjectLong pairOfObjectLong6 = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"f", pairOfObjectLong6.getLeftElement());
        Assert.assertEquals((long)9L, (long)pairOfObjectLong6.getRightElement());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Object2LongFrequencyDistributionTest.class);
    }
}

