/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import com.google.common.collect.Lists;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.sux4j.mph.TwoStepsLcpMonotoneMinimalPerfectHashFunction;
import it.unimi.dsi.util.FrontCodedStringList;
import it.unimi.dsi.util.ShiftAddXorSignedStringMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class FrontCodedString2IntBidiMapBuilder {
    private static final Logger LOG = Logger.getLogger(FrontCodedString2IntBidiMapBuilder.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";

    public static void main(String[] args) throws Exception {
        String line;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(FrontCodedString2IntBidiMapBuilder.class.getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String input = cmdline.getOptionValue(INPUT);
        String output = cmdline.getOptionValue(OUTPUT);
        ArrayList stringList = Lists.newArrayList();
        IntArrayList intList = new IntArrayList();
        Object2IntAVLTreeMap tree = new Object2IntAVLTreeMap();
        BufferedReader br = new BufferedReader(new FileReader(input));
        while ((line = br.readLine()) != null) {
            String[] arr = line.split("\\t");
            if (arr[0] == null || arr[0].length() == 0) {
                LOG.info((Object)("Skipping invalid line: " + line));
            }
            tree.put((Object)arr[0], Integer.parseInt(arr[1]));
        }
        br.close();
        for (Object2IntMap.Entry map : tree.object2IntEntrySet()) {
            stringList.add(map.getKey());
            intList.add(map.getIntValue());
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(new Path(output), true);
        FrontCodedStringList frontcodedList = new FrontCodedStringList((Collection)stringList, 8, true);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        objOut.writeObject(frontcodedList);
        objOut.close();
        byte[] bytes = bytesOut.toByteArray();
        os.writeInt(bytes.length);
        os.write(bytes);
        ShiftAddXorSignedStringMap dict = new ShiftAddXorSignedStringMap(stringList.iterator(), (Object2LongFunction)new TwoStepsLcpMonotoneMinimalPerfectHashFunction((Iterable)stringList, TransformationStrategies.prefixFreeUtf16()));
        bytesOut = new ByteArrayOutputStream();
        objOut = new ObjectOutputStream(bytesOut);
        objOut.writeObject(dict);
        objOut.close();
        bytes = bytesOut.toByteArray();
        os.writeInt(bytes.length);
        os.write(bytes);
        os.writeInt(intList.size());
        for (int i = 0; i < intList.size(); ++i) {
            os.writeInt(intList.getInt(i));
        }
        os.close();
    }
}

