/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.MapID;
import edu.umd.cloud9.util.map.MapII;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HMapID
implements MapID,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<MapID.Entry> entrySet = null;
    volatile transient Set<Integer> keySet = null;
    volatile transient Collection<Double> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HMapID(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HMapID(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HMapID() {
        this.loadFactor = 0.75f;
        this.threshold = 768;
        this.table = new Entry[1024];
        this.init();
    }

    public HMapID(MapID m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1024), 0.75f);
        this.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public double get(int key) {
        int hash = HMapID.hash(key);
        Entry e = this.table[HMapID.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e.value;
            }
            e = e.next;
        }
        return 0.0;
    }

    @Override
    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    final Entry getEntry(int key) {
        int hash = HMapID.hash(key);
        Entry e = this.table[HMapID.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public double put(int key, double value) {
        int hash = HMapID.hash(key);
        int i = HMapID.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                double oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return 0.0;
    }

    private void putForCreate(int key, double value) {
        int hash = HMapID.hash(key);
        int i = HMapID.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(MapID m) {
        for (MapID.Entry e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HMapID.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(MapID m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (MapID.Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void increment(int key, double value) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + value);
        } else {
            this.put(key, value);
        }
    }

    @Override
    public double remove(int key) {
        Entry e = this.removeEntryForKey(key);
        if (e != null) {
            return e.value;
        }
        throw new NoSuchElementException();
    }

    final Entry removeEntryForKey(int key) {
        Entry prev;
        int hash = HMapID.hash(key);
        int i = HMapID.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            int k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry removeMapping(Object o) {
        Entry prev;
        MapII.Entry entry = (MapII.Entry)o;
        Integer key = entry.getKey();
        int hash = key == null ? 0 : HMapID.hash(((Object)key).hashCode());
        int i = HMapID.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(double value) {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HMapID result = null;
        try {
            result = (HMapID)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, int key, double value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, int key, double value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        ++this.size;
    }

    Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Double> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<MapID.Entry> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Double> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<MapID.Entry> entrySet() {
        return this.entrySet0();
    }

    private Set<MapID.Entry> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<MapID.Entry> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                MapID.Entry e = i.next();
                s.writeInt(e.getKey());
                s.writeDouble(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            double value = s.readDouble();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<MapID.Entry> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            MapID.Entry e = i.next();
            int key = e.getKey();
            double value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public void plus(MapID m) {
        for (MapID.Entry e : m.entrySet()) {
            int key = e.getKey();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + e.getValue());
                continue;
            }
            this.put(key, e.getValue());
        }
    }

    public double dot(MapID m) {
        double s = 0.0;
        for (MapID.Entry e : m.entrySet()) {
            int key = e.getKey();
            if (!this.containsKey(key)) continue;
            s += this.get(key) * e.getValue();
        }
        return s;
    }

    public double length() {
        double s = 0.0;
        for (MapID.Entry e : this.entrySet()) {
            s += e.getValue() * e.getValue();
        }
        return Math.sqrt(s);
    }

    public void normalize() {
        double l = this.length();
        for (int f : this.keySet()) {
            this.put(f, this.get(f) / l);
        }
    }

    public MapID.Entry[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        MapID.Entry[] entries = new Entry[this.size()];
        int i = 0;
        Entry next = null;
        int index = 0;
        while (index < this.table.length && (next = this.table[index++]) == null) {
        }
        while (next != null) {
            Entry e = next;
            next = e.next;
            next = e.next;
            if (next == null) {
                while (index < this.table.length && (next = this.table[index++]) == null) {
                }
            }
            entries[i++] = e;
        }
        Arrays.sort(entries, new Comparator<MapID.Entry>(){

            @Override
            public int compare(MapID.Entry e1, MapID.Entry e2) {
                if (e1.getValue() > e2.getValue()) {
                    return -1;
                }
                if (e1.getValue() < e2.getValue()) {
                    return 1;
                }
                if (e1.getKey() == e2.getKey()) {
                    return 0;
                }
                return e1.getKey() > e2.getKey() ? 1 : -1;
            }
        });
        return entries;
    }

    public MapID.Entry[] getEntriesSortedByValue(int n) {
        MapID.Entry[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < n) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, n);
    }

    private final class EntrySet
    extends AbstractSet<MapID.Entry> {
        private EntrySet() {
        }

        @Override
        public Iterator<MapID.Entry> iterator() {
            return HMapID.this.newEntryIterator();
        }

        @Override
        public int size() {
            return HMapID.this.size;
        }

        @Override
        public boolean contains(Object o) {
            MapID.Entry e = (MapID.Entry)o;
            Entry candidate = HMapID.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }
    }

    private final class Values
    extends AbstractCollection<Double> {
        private Values() {
        }

        @Override
        public Iterator<Double> iterator() {
            return HMapID.this.newValueIterator();
        }

        @Override
        public int size() {
            return HMapID.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapID.this.containsValue((Double)o);
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return HMapID.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HMapID.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapID.this.containsKey((Integer)o);
        }
    }

    private final class EntryIterator
    extends HashIterator<MapID.Entry> {
        private EntryIterator() {
        }

        @Override
        public MapID.Entry next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<Double> {
        private ValueIterator() {
        }

        @Override
        public Double next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = HMapID.this.modCount;
            if (HMapID.this.size > 0) {
                Entry[] t = HMapID.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (HMapID.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = HMapID.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HMapID.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            HMapID.this.removeEntryForKey(k);
            this.expectedModCount = HMapID.this.modCount;
        }
    }

    static class Entry
    implements MapID.Entry {
        final int key;
        double value;
        Entry next;
        final int hash;

        Entry(int h, int k, double v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        public final double getValue() {
            return this.value;
        }

        @Override
        public final double setValue(double newValue) {
            double oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            double v2;
            double v1;
            int k2;
            MapID.Entry e = (MapID.Entry)o;
            int k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        @Override
        public final int hashCode() {
            return this.key ^ (int)this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HMapID m) {
        }

        void recordRemoval(HMapID m) {
        }
    }
}

