/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapID;
import edu.umd.cloud9.util.map.MapID;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapIDTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        double[] doubles = new double[size];
        HMapID map = new HMapID();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (double)k + 0.1);
            doubles[i] = (double)k + 0.1;
        }
        for (i = 0; i < size; ++i) {
            double v = map.get(i);
            Assert.assertEquals((double)doubles[i], (double)v, (double)0.0);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        double[] doubles = new double[size];
        HMapID map = new HMapID();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (double)k + 0.1);
            doubles[i] = (double)k + 0.1;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, doubles[i] + 1.0);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            double v = map.get(i);
            Assert.assertEquals((double)(doubles[i] + 1.0), (double)v, (double)0.0);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapID m = new HMapID();
        m.put(1, 5.0);
        m.put(2, 22.0);
        Assert.assertEquals((long)m.size(), (long)2L);
        double value = m.get(1);
        Assert.assertTrue((value == 5.0 ? 1 : 0) != 0);
        value = m.remove(1);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(2);
        Assert.assertTrue((value == 22.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapID m1 = new HMapID();
        m1.put(1, 5.0);
        m1.put(2, 22.0);
        HMapID m2 = new HMapID();
        m2.put(1, 4.0);
        m2.put(3, 5.0);
        m1.plus(m2);
        Assert.assertEquals((long)m1.size(), (long)3L);
        Assert.assertTrue((m1.get(1) == 9.0 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(2) == 22.0 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(3) == 5.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapID m1 = new HMapID();
        m1.put(1, 2.3);
        m1.put(2, 1.9);
        m1.put(3, 3.0);
        HMapID m2 = new HMapID();
        m2.put(1, 1.2);
        m2.put(2, 4.3);
        m2.put(4, 5.0);
        double s = m1.dot(m2);
        Assert.assertTrue((s == 10.93 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testLengthAndNormalize() throws IOException {
        HMapID m1 = new HMapID();
        m1.put(1, 2.3);
        m1.put(2, 1.9);
        m1.put(3, 3.0);
        Assert.assertEquals((double)m1.length(), (double)4.2308393, (double)1.0E-5);
        m1.normalize();
        Assert.assertEquals((double)m1.get(1), (double)0.5436274, (double)1.0E-5);
        Assert.assertEquals((double)m1.get(2), (double)0.44908348, (double)1.0E-5);
        Assert.assertEquals((double)m1.get(3), (double)0.70907915, (double)1.0E-5);
        Assert.assertEquals((double)m1.length(), (double)1.0, (double)1.0E-5);
        HMapID m2 = new HMapID();
        m2.put(1, 1.2);
        m2.put(2, 4.3);
        m2.put(3, 5.0);
        Assert.assertEquals((double)m2.length(), (double)6.7029843, (double)1.0E-5);
        m2.normalize();
        Assert.assertEquals((double)m2.get(1), (double)0.17902474, (double)1.0E-5);
        Assert.assertEquals((double)m2.get(2), (double)0.64150536, (double)1.0E-5);
        Assert.assertEquals((double)m2.get(3), (double)0.7459364, (double)1.0E-5);
        Assert.assertEquals((double)m2.length(), (double)1.0, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapID m = new HMapID();
        m.put(1, 5.0);
        m.put(2, 2.0);
        m.put(3, 3.0);
        m.put(4, 3.0);
        m.put(5, 1.0);
        MapID.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((double)5.0, (double)e[0].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((double)3.0, (double)e[1].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)4L, (long)e[2].getKey());
        Assert.assertEquals((double)3.0, (double)e[2].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)e[3].getKey());
        Assert.assertEquals((double)2.0, (double)e[3].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)e[4].getKey());
        Assert.assertEquals((double)1.0, (double)e[4].getValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapID m = new HMapID();
        m.put(1, 5.0);
        m.put(2, 2.0);
        m.put(3, 3.0);
        m.put(4, 3.0);
        m.put(5, 1.0);
        MapID.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((double)5.0, (double)e[0].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((double)3.0, (double)e[1].getValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries3() {
        HMapID m = new HMapID();
        m.put(1, 5.0);
        m.put(2, 2.0);
        MapID.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((double)5.0, (double)e[0].getValue(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((double)2.0, (double)e[1].getValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries4() {
        HMapID m = new HMapID();
        MapID.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIncrement() {
        HMapID m = new HMapID();
        Assert.assertEquals((double)0.0, (double)m.get(1), (double)1.0E-5);
        m.increment(1, 0.5);
        Assert.assertEquals((double)0.5, (double)m.get(1), (double)1.0E-5);
        m.increment(1, 1.0);
        m.increment(2, 0.0);
        m.increment(3, -0.5);
        Assert.assertEquals((double)1.5, (double)m.get(1), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)m.get(2), (double)1.0E-5);
        Assert.assertEquals((double)-0.5, (double)m.get(3), (double)1.0E-5);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIDTest.class);
    }
}

