/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapIS;
import edu.umd.cloud9.util.map.MapIS;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapISTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 10000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapIS map = new HMapIS();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (short)(k * 2));
            shorts[i] = (short)(k * 2);
        }
        for (i = 0; i < size; ++i) {
            short v = map.get(i);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 10000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapIS map = new HMapIS();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (short)(k + 10));
            shorts[i] = (short)(k + 10);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, (short)(shorts[i] + 10));
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            short v = map.get(i);
            Assert.assertEquals((long)(shorts[i] + 10), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIS m = new HMapIS();
        m.put(1, (short)5);
        m.put(2, (short)22);
        Assert.assertEquals((long)2L, (long)m.size());
        short value = m.get(1);
        Assert.assertEquals((long)5L, (long)value);
        value = m.remove(1);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(2);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapIS m1 = new HMapIS();
        m1.put(1, (short)5);
        m1.put(2, (short)22);
        HMapIS m2 = new HMapIS();
        m2.put(1, (short)4);
        m2.put(3, (short)5);
        m1.plus(m2);
        Assert.assertEquals((long)m1.size(), (long)3L);
        Assert.assertTrue((m1.get(1) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(2) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(3) == 5 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapIS m1 = new HMapIS();
        m1.put(1, (short)2);
        m1.put(2, (short)1);
        m1.put(3, (short)3);
        HMapIS m2 = new HMapIS();
        m2.put(1, (short)1);
        m2.put(2, (short)4);
        m2.put(4, (short)5);
        int s = m1.dot(m2);
        Assert.assertEquals((long)6L, (long)s);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapIS m = new HMapIS();
        m.put(1, (short)5);
        m.put(2, (short)2);
        m.put(3, (short)3);
        m.put(4, (short)3);
        m.put(5, (short)1);
        MapIS.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
        Assert.assertEquals((long)4L, (long)e[2].getKey());
        Assert.assertEquals((long)3L, (long)e[2].getValue());
        Assert.assertEquals((long)2L, (long)e[3].getKey());
        Assert.assertEquals((long)2L, (long)e[3].getValue());
        Assert.assertEquals((long)5L, (long)e[4].getKey());
        Assert.assertEquals((long)1L, (long)e[4].getValue());
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapIS m = new HMapIS();
        m.put(1, (short)5);
        m.put(2, (short)2);
        m.put(3, (short)3);
        m.put(4, (short)3);
        m.put(5, (short)1);
        MapIS.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries3() {
        HMapIS m = new HMapIS();
        m.put(1, (short)5);
        m.put(2, (short)2);
        MapIS.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((long)2L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries4() {
        HMapIS m = new HMapIS();
        MapIS.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIncrement() {
        HMapIS m = new HMapIS();
        Assert.assertEquals((long)0L, (long)m.get(1));
        m.increment(1, (short)1);
        Assert.assertEquals((long)1L, (long)m.get(1));
        m.increment(1, (short)1);
        m.increment(2, (short)0);
        m.increment(3, (short)-1);
        Assert.assertEquals((long)2L, (long)m.get(1));
        Assert.assertEquals((long)0L, (long)m.get(2));
        Assert.assertEquals((long)-1L, (long)m.get(3));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapISTest.class);
    }
}

