/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapIV;
import edu.umd.cloud9.util.map.MapIV;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapIVTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        String[] strings = new String[size];
        HMapIV<String> map = new HMapIV<String>();
        for (i = 0; i < size; ++i) {
            String s = new Integer(r.nextInt(size)).toString();
            map.put(i, s);
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            String v = (String)map.get(i);
            Assert.assertEquals((Object)strings[i], (Object)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        String[] strings = new String[size];
        HMapIV<String> map = new HMapIV<String>();
        for (i = 0; i < size; ++i) {
            String s = new Integer(r.nextInt(size)).toString();
            map.put(i, s);
            strings[i] = s;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, new Integer(Integer.parseInt(strings[i]) + 1).toString());
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            String v = (String)map.get(i);
            Assert.assertEquals((Object)new Integer(Integer.parseInt(strings[i]) + 1).toString(), (Object)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIV<String> m = new HMapIV<String>();
        m.put(1, "5");
        m.put(2, "22");
        Assert.assertEquals((long)2L, (long)m.size());
        String value = (String)m.get(1);
        Assert.assertEquals((Object)"5", m.get(1));
        value = (String)m.remove(1);
        Assert.assertEquals((long)1L, (long)m.size());
        value = (String)m.get(2);
        Assert.assertEquals((Object)"22", (Object)value);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapIV<String> m = new HMapIV<String>();
        m.put(1, "5");
        m.put(2, "2");
        m.put(3, "3");
        m.put(4, "3");
        m.put(5, "1");
        MapIV.Entry<V>[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)5L, (long)e[0].getKey());
        Assert.assertEquals((Object)"1", e[0].getValue());
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((Object)"2", e[1].getValue());
        Assert.assertEquals((long)3L, (long)e[2].getKey());
        Assert.assertEquals((Object)"3", e[2].getValue());
        Assert.assertEquals((long)4L, (long)e[3].getKey());
        Assert.assertEquals((Object)"3", e[3].getValue());
        Assert.assertEquals((long)1L, (long)e[4].getKey());
        Assert.assertEquals((Object)"5", e[4].getValue());
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapIV<String> m = new HMapIV<String>();
        m.put(1, "5");
        m.put(2, "2");
        m.put(3, "3");
        m.put(4, "3");
        m.put(5, "1");
        MapIV.Entry<V>[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)5L, (long)e[0].getKey());
        Assert.assertEquals((Object)"1", e[0].getValue());
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((Object)"2", e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries3() {
        HMapIV<String> m = new HMapIV<String>();
        m.put(1, "5");
        m.put(2, "2");
        MapIV.Entry<V>[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)2L, (long)e[0].getKey());
        Assert.assertEquals((Object)"2", e[0].getValue());
        Assert.assertEquals((long)1L, (long)e[1].getKey());
        Assert.assertEquals((Object)"5", e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries4() {
        HMapIV m = new HMapIV();
        MapIV.Entry<V>[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIVTest.class);
    }
}

