/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapKI;
import edu.umd.cloud9.util.map.MapKI;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class HMapKITest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapKI<Integer> map = new HMapKI<Integer>();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            int v = map.get(i);
            Assert.assertEquals((long)ints[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        String[] strings = new String[size];
        HMapKI<String> map = new HMapKI<String>();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put(s, k);
            ints[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            int v = map.get(strings[i]);
            Assert.assertEquals((long)ints[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapKI<Integer> map = new HMapKI<Integer>();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            int v = map.get(i);
            Assert.assertEquals((long)(ints[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testToString() throws IOException {
        HMapKI<String> m1 = new HMapKI<String>();
        m1.put("hi", 5);
        m1.put("there", 22);
        Assert.assertEquals((Object)"{there=22, hi=5}", (Object)m1.toString());
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKI<Text> m = new HMapKI<Text>();
        m.put(new Text("hi"), 5);
        m.put(new Text("there"), 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        int value = m.get(key);
        Assert.assertEquals((long)value, (long)5L);
        value = m.remove(key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get(key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapKI<Object> m1 = new HMapKI<Object>();
        m1.put((Object)new Text("hi"), 5);
        m1.put((Object)new Text("there"), 22);
        HMapKI<Text> m2 = new HMapKI<Text>();
        m2.put(new Text("hi"), 4);
        m2.put(new Text("test"), 5);
        m1.plus(m2);
        Assert.assertEquals((long)3L, (long)m1.size());
        Assert.assertTrue((m1.get((Object)new Text("hi")) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)new Text("there")) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)new Text("test")) == 5 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapKI<Object> m1 = new HMapKI<Object>();
        m1.put((Object)new Text("hi"), 5);
        m1.put((Object)new Text("there"), 2);
        m1.put((Object)new Text("empty"), 3);
        HMapKI<Text> m2 = new HMapKI<Text>();
        m2.put(new Text("hi"), 4);
        m2.put(new Text("there"), 4);
        m2.put(new Text("test"), 5);
        int s = m1.dot(m2);
        Assert.assertEquals((long)s, (long)28L);
    }

    @org.junit.Test
    public void testSortedEntriesValue1() {
        HMapKI<Text> m = new HMapKI<Text>();
        m.put(new Text("a"), 5);
        m.put(new Text("b"), 2);
        m.put(new Text("c"), 3);
        m.put(new Text("d"), 3);
        m.put(new Text("e"), 1);
        MapKI.Entry<K>[] entries = m.getEntriesSortedByValue();
        MapKI.Entry e = null;
        Assert.assertEquals((long)5L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[2];
        Assert.assertEquals((Object)new Text("d"), e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[3];
        Assert.assertEquals((Object)new Text("b"), e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
        e = entries[4];
        Assert.assertEquals((Object)new Text("e"), e.getKey());
        Assert.assertEquals((long)1L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesValue2() {
        HMapKI<Text> m = new HMapKI<Text>();
        m.put(new Text("a"), 5);
        m.put(new Text("b"), 2);
        m.put(new Text("c"), 3);
        m.put(new Text("d"), 3);
        m.put(new Text("e"), 1);
        MapKI.Entry<K>[] entries = m.getEntriesSortedByValue(2);
        MapKI.Entry e = null;
        Assert.assertEquals((long)2L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesKey1() {
        HMapKI<Text> m = new HMapKI<Text>();
        m.put(new Text("a"), 5);
        m.put(new Text("b"), 2);
        m.put(new Text("c"), 3);
        m.put(new Text("d"), 3);
        m.put(new Text("e"), 1);
        MapKI.Entry<K>[] entries = m.getEntriesSortedByKey();
        MapKI.Entry e = null;
        Assert.assertEquals((long)5L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("b"), e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
        e = entries[2];
        Assert.assertEquals((Object)new Text("c"), e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[3];
        Assert.assertEquals((Object)new Text("d"), e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[4];
        Assert.assertEquals((Object)new Text("e"), e.getKey());
        Assert.assertEquals((long)1L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesKey2() {
        HMapKI<Text> m = new HMapKI<Text>();
        m.put(new Text("a"), 5);
        m.put(new Text("b"), 2);
        m.put(new Text("c"), 3);
        m.put(new Text("d"), 3);
        m.put(new Text("e"), 1);
        MapKI.Entry<K>[] entries = m.getEntriesSortedByKey(2);
        MapKI.Entry e = null;
        Assert.assertEquals((long)2L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("b"), e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKI<String> m = new HMapKI<String>();
        Assert.assertEquals((long)0L, (long)m.get("one"));
        m.increment("one");
        Assert.assertEquals((long)1L, (long)m.get("one"));
        m.increment("one", 5);
        m.increment("two", 0);
        m.increment("three", 2);
        Assert.assertEquals((long)6L, (long)m.get("one"));
        Assert.assertEquals((long)0L, (long)m.get("two"));
        Assert.assertEquals((long)2L, (long)m.get("three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKITest.class);
    }
}

