/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.MapKL;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HMapKL<K>
implements MapKL<K>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<MapKL.Entry<K>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<Long> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HMapKL(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HMapKL(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HMapKL() {
        this.loadFactor = 0.75f;
        this.threshold = 768;
        this.table = new Entry[1024];
        this.init();
    }

    public HMapKL(MapKL<? extends K> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1024), 0.75f);
        super.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long get(K key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = HMapKL.hash(key.hashCode());
        Entry<K> e = this.table[HMapKL.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        return 0L;
    }

    private long getForNullKey() {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return 0L;
    }

    @Override
    public boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    final Entry<K> getEntry(Object key) {
        int hash = key == null ? 0 : HMapKL.hash(key.hashCode());
        Entry<K> e = this.table[HMapKL.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public void increment(K key) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + 1L);
        } else {
            this.put(key, 1L);
        }
    }

    public void increment(K key, long value) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + value);
        } else {
            this.put(key, value);
        }
    }

    @Override
    public long put(K key, long value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = HMapKL.hash(key.hashCode());
        int i = HMapKL.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                long oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return 0L;
    }

    private long putForNullKey(long value) {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                long oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return 0L;
    }

    private void putForCreate(K key, long value) {
        int hash = key == null ? 0 : HMapKL.hash(key.hashCode());
        int i = HMapKL.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(MapKL<? extends K> m) {
        for (MapKL.Entry<K> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<K>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K>[] newTable) {
        Entry<K>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<K> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HMapKL.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(MapKL<? extends K> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (MapKL.Entry<K> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public long remove(K key) {
        Entry<K> e = this.removeEntryForKey(key);
        if (e != null) {
            return e.value;
        }
        throw new NoSuchElementException();
    }

    final Entry<K> removeEntryForKey(Object key) {
        Entry<K> prev;
        int hash = key == null ? 0 : HMapKL.hash(key.hashCode());
        int i = HMapKL.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry<K> removeMapping(Object o) {
        Entry<K> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        MapKL.Entry entry = (MapKL.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : HMapKL.hash(key.hashCode());
        int i = HMapKL.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(long value) {
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K> e = tab[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HMapKL result = null;
        try {
            result = (HMapKL)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, K key, long value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, long value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Long> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<MapKL.Entry<K>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Long> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<MapKL.Entry<K>> entrySet() {
        return this.entrySet0();
    }

    private Set<MapKL.Entry<K>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<MapKL.Entry<K>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                MapKL.Entry<K> e = i.next();
                s.writeObject(e.getKey());
                s.writeLong(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            long value = s.readLong();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<MapKL.Entry<K>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            MapKL.Entry<K> e = i.next();
            K key = e.getKey();
            long value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private final class EntrySet
    extends AbstractSet<MapKL.Entry<K>> {
        private EntrySet() {
        }

        @Override
        public Iterator<MapKL.Entry<K>> iterator() {
            return HMapKL.this.newEntryIterator();
        }

        @Override
        public int size() {
            return HMapKL.this.size;
        }

        @Override
        public boolean contains(Object o) {
            MapKL.Entry e = (MapKL.Entry)o;
            Entry candidate = HMapKL.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }
    }

    private final class Values
    extends AbstractCollection<Long> {
        private Values() {
        }

        @Override
        public Iterator<Long> iterator() {
            return HMapKL.this.newValueIterator();
        }

        @Override
        public int size() {
            return HMapKL.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKL.this.containsValue((Long)o);
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HMapKL.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HMapKL.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKL.this.containsKey(o);
        }
    }

    private final class EntryIterator
    extends HashIterator<MapKL.Entry<K>> {
        private EntryIterator() {
        }

        @Override
        public MapKL.Entry<K> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<Long> {
        private ValueIterator() {
        }

        @Override
        public Long next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K> next;
        int expectedModCount;
        int index;
        Entry<K> current;

        HashIterator() {
            this.expectedModCount = HMapKL.this.modCount;
            if (HMapKL.this.size > 0) {
                Entry<K>[] t = HMapKL.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K> nextEntry() {
            if (HMapKL.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry<K>[] t = HMapKL.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HMapKL.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            HMapKL.this.removeEntryForKey(k);
            this.expectedModCount = HMapKL.this.modCount;
        }
    }

    static class Entry<K>
    implements MapKL.Entry<K> {
        final K key;
        long value;
        Entry<K> next;
        final int hash;

        Entry(int h, K k, long v, Entry<K> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final long getValue() {
            return this.value;
        }

        @Override
        public final long setValue(long newValue) {
            long oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            long v2;
            long v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            MapKL.Entry e = (MapKL.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (int)this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HMapKL<K> m) {
        }

        void recordRemoval(HMapKL<K> m) {
        }
    }
}

