/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapKL;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapKLTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL<Integer> map = new HMapKL<Integer>();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            map.put(i, k);
            longs[i] = k;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get(i);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        String[] strings = new String[size];
        HMapKL<String> map = new HMapKL<String>();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put(s, k);
            longs[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get(strings[i]);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL<Integer> map = new HMapKL<Integer>();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            longs[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, longs[i] + 1L);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            long v = map.get(i);
            Assert.assertEquals((long)(longs[i] + 1L), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKL<String> m = new HMapKL<String>();
        Assert.assertEquals((long)0L, (long)m.get("one"));
        m.increment("one", 1L);
        Assert.assertEquals((long)1L, (long)m.get("one"));
        m.increment("one", 1L);
        m.increment("two", 0L);
        m.increment("three", -1L);
        Assert.assertEquals((long)2L, (long)m.get("one"));
        Assert.assertEquals((long)0L, (long)m.get("two"));
        Assert.assertEquals((long)-1L, (long)m.get("three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKLTest.class);
    }
}

