/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.HMapKS;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapKSTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS<Integer> map = new HMapKS<Integer>();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put(i, k);
            shorts[i] = k;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get(i);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        String[] strings = new String[size];
        HMapKS<String> map = new HMapKS<String>();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            String s = new Integer(k).toString();
            map.put(s, k);
            shorts[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get(strings[i]);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS<Integer> map = new HMapKS<Integer>();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put(i, k);
            shorts[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, (short)(shorts[i] + 1));
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            short v = map.get(i);
            Assert.assertEquals((long)(shorts[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKS<String> m = new HMapKS<String>();
        Assert.assertEquals((long)0L, (long)m.get("one"));
        m.increment("one", (short)1);
        Assert.assertEquals((long)1L, (long)m.get("one"));
        m.increment("one", (short)1);
        m.increment("two", (short)0);
        m.increment("three", (short)-1);
        Assert.assertEquals((long)2L, (long)m.get("one"));
        Assert.assertEquals((long)0L, (long)m.get("two"));
        Assert.assertEquals((long)-1L, (long)m.get("three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKSTest.class);
    }
}

