/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import edu.umd.cloud9.util.map.MapIV;
import edu.umd.cloud9.util.map.NavigableMapIV;
import edu.umd.cloud9.util.map.SortedMapIV;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TMapIV<V>
implements NavigableMapIV<V>,
Cloneable,
Serializable {
    private transient Entry<V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet = null;
    private transient KeySet navigableKeySet = null;
    private transient NavigableMapIV<V> descendingMap = null;
    Collection<V> vs;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TMapIV() {
    }

    public TMapIV(MapIV<V> m) {
        this.putAll(m);
    }

    public TMapIV(SortedMapIV<? extends V> m) {
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<V> e = this.getFirstEntry();
        while (e != null) {
            if (TMapIV.valEquals(value, e.value)) {
                return true;
            }
            e = TMapIV.successor(e);
        }
        return false;
    }

    @Override
    public V get(int key) {
        Entry<V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public int firstKey() {
        return this.getFirstEntry().key;
    }

    @Override
    public int lastKey() {
        return this.getLastEntry().key;
    }

    @Override
    public void putAll(MapIV<V> m) {
        for (MapIV.Entry<V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    final Entry<V> getEntry(int key) {
        Entry<V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    final Entry<V> getCeilingEntry(int key) {
        Entry<V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                Entry parent = p.parent;
                Entry<V> ch = p;
                while (parent != null && ch == parent.right) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    final Entry<V> getFloorEntry(int key) {
        Entry<V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                Entry parent = p.parent;
                Entry<V> ch = p;
                while (parent != null && ch == parent.left) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    final Entry<V> getHigherEntry(int key) {
        Entry<V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right != null) {
                p = p.right;
                continue;
            }
            Entry parent = p.parent;
            Entry<V> ch = p;
            while (parent != null && ch == parent.right) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    final Entry<V> getLowerEntry(int key) {
        Entry<V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left != null) {
                p = p.left;
                continue;
            }
            Entry parent = p.parent;
            Entry<V> ch = p;
            while (parent != null && ch == parent.left) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    @Override
    public V put(int key, V value) {
        int cmp;
        Entry<V> parent;
        Entry<V> t = this.root;
        if (t == null) {
            this.root = new Entry<V>(key, value, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        do {
            parent = t;
            cmp = this.compare(key, t.key);
            if (cmp < 0) {
                t = t.left;
                continue;
            }
            if (cmp > 0) {
                t = t.right;
                continue;
            }
            return t.setValue(value);
        } while (t != null);
        Entry<V> e = new Entry<V>(key, value, parent);
        if (cmp < 0) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        this.fixAfterInsertion(e);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public V remove(int key) {
        Entry<V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Object clone() {
        TMapIV clone = null;
        try {
            clone = (TMapIV)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.navigableKeySet = null;
        clone.descendingMap = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public MapIV.Entry<V> firstEntry() {
        return TMapIV.exportEntry(this.getFirstEntry());
    }

    @Override
    public MapIV.Entry<V> lastEntry() {
        return TMapIV.exportEntry(this.getLastEntry());
    }

    @Override
    public MapIV.Entry<V> pollFirstEntry() {
        Entry<V> p = this.getFirstEntry();
        MapIV.Entry<V> result = TMapIV.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public MapIV.Entry<V> pollLastEntry() {
        Entry<V> p = this.getLastEntry();
        MapIV.Entry<V> result = TMapIV.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public MapIV.Entry<V> lowerEntry(int key) {
        return TMapIV.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public int lowerKey(int key) {
        return this.getLowerEntry((int)key).key;
    }

    @Override
    public MapIV.Entry<V> floorEntry(int key) {
        return TMapIV.exportEntry(this.getFloorEntry(key));
    }

    @Override
    public int floorKey(int key) {
        return this.getFloorEntry((int)key).key;
    }

    @Override
    public MapIV.Entry<V> ceilingEntry(int key) {
        return TMapIV.exportEntry(this.getCeilingEntry(key));
    }

    @Override
    public int ceilingKey(int key) {
        return this.getCeilingEntry((int)key).key;
    }

    @Override
    public MapIV.Entry<V> higherEntry(int key) {
        return TMapIV.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public int higherKey(int key) {
        return this.getHigherEntry((int)key).key;
    }

    @Override
    public Set<Integer> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<Integer> navigableKeySet() {
        KeySet nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public NavigableSet<Integer> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        return this.vs != null ? this.vs : (this.vs = new Values());
    }

    @Override
    public Set<MapIV.Entry<V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public NavigableMapIV<V> descendingMap() {
        NavigableMapIV<V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingSubMap(this, true, Integer.MIN_VALUE, true, true, Integer.MAX_VALUE, true));
    }

    @Override
    public NavigableMapIV<V> subMap(int fromKey, boolean fromInclusive, int toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public NavigableMapIV<V> headMap(int toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, Integer.MIN_VALUE, true, false, toKey, inclusive);
    }

    @Override
    public NavigableMapIV<V> tailMap(int fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey, inclusive, true, Integer.MAX_VALUE, true);
    }

    @Override
    public SortedMapIV<V> subMap(int fromKey, int toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMapIV<V> headMap(int toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMapIV<V> tailMap(int fromKey) {
        return this.tailMap(fromKey, true);
    }

    Iterator<Integer> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    Iterator<Integer> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(int k1, int k2) {
        return k1 == k2 ? 0 : (k1 > k2 ? 1 : -1);
    }

    static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static <K, V> MapIV.Entry<V> exportEntry(Entry<V> e) {
        return e == null ? null : new SimpleImmutableEntry<V>(e);
    }

    final Entry<V> getFirstEntry() {
        Entry<V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    final Entry<V> getLastEntry() {
        Entry<V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    static <V> Entry<V> successor(Entry<V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    static <V> Entry<V> predecessor(Entry<V> t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            Entry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<V> ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <V> boolean colorOf(Entry<V> p) {
        return p == null ? true : p.color;
    }

    private static <V> Entry<V> parentOf(Entry<V> p) {
        return p == null ? null : p.parent;
    }

    private static <V> void setColor(Entry<V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <V> Entry<V> leftOf(Entry<V> p) {
        return p == null ? null : p.left;
    }

    private static <V> Entry<V> rightOf(Entry<V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry<V> p) {
        if (p != null) {
            Entry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
        }
    }

    private void rotateRight(Entry<V> p) {
        if (p != null) {
            Entry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
        }
    }

    private void fixAfterInsertion(Entry<V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry<V> y;
            if (TMapIV.parentOf(x) == TMapIV.leftOf(TMapIV.parentOf(TMapIV.parentOf(x)))) {
                y = TMapIV.rightOf(TMapIV.parentOf(TMapIV.parentOf(x)));
                if (!TMapIV.colorOf(y)) {
                    TMapIV.setColor(TMapIV.parentOf(x), true);
                    TMapIV.setColor(y, true);
                    TMapIV.setColor(TMapIV.parentOf(TMapIV.parentOf(x)), false);
                    x = TMapIV.parentOf(TMapIV.parentOf(x));
                    continue;
                }
                if (x == TMapIV.rightOf(TMapIV.parentOf(x))) {
                    x = TMapIV.parentOf(x);
                    this.rotateLeft(x);
                }
                TMapIV.setColor(TMapIV.parentOf(x), true);
                TMapIV.setColor(TMapIV.parentOf(TMapIV.parentOf(x)), false);
                this.rotateRight(TMapIV.parentOf(TMapIV.parentOf(x)));
                continue;
            }
            y = TMapIV.leftOf(TMapIV.parentOf(TMapIV.parentOf(x)));
            if (!TMapIV.colorOf(y)) {
                TMapIV.setColor(TMapIV.parentOf(x), true);
                TMapIV.setColor(y, true);
                TMapIV.setColor(TMapIV.parentOf(TMapIV.parentOf(x)), false);
                x = TMapIV.parentOf(TMapIV.parentOf(x));
                continue;
            }
            if (x == TMapIV.leftOf(TMapIV.parentOf(x))) {
                x = TMapIV.parentOf(x);
                this.rotateRight(x);
            }
            TMapIV.setColor(TMapIV.parentOf(x), true);
            TMapIV.setColor(TMapIV.parentOf(TMapIV.parentOf(x)), false);
            this.rotateLeft(TMapIV.parentOf(TMapIV.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<V> p) {
        Entry replacement;
        ++this.modCount;
        --this.size;
        if (p.left != null && p.right != null) {
            Entry<V> s = TMapIV.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<V> x) {
        while (x != this.root && TMapIV.colorOf(x)) {
            Entry<V> sib;
            if (x == TMapIV.leftOf(TMapIV.parentOf(x))) {
                sib = TMapIV.rightOf(TMapIV.parentOf(x));
                if (!TMapIV.colorOf(sib)) {
                    TMapIV.setColor(sib, true);
                    TMapIV.setColor(TMapIV.parentOf(x), false);
                    this.rotateLeft(TMapIV.parentOf(x));
                    sib = TMapIV.rightOf(TMapIV.parentOf(x));
                }
                if (TMapIV.colorOf(TMapIV.leftOf(sib)) && TMapIV.colorOf(TMapIV.rightOf(sib))) {
                    TMapIV.setColor(sib, false);
                    x = TMapIV.parentOf(x);
                    continue;
                }
                if (TMapIV.colorOf(TMapIV.rightOf(sib))) {
                    TMapIV.setColor(TMapIV.leftOf(sib), true);
                    TMapIV.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TMapIV.rightOf(TMapIV.parentOf(x));
                }
                TMapIV.setColor(sib, TMapIV.colorOf(TMapIV.parentOf(x)));
                TMapIV.setColor(TMapIV.parentOf(x), true);
                TMapIV.setColor(TMapIV.rightOf(sib), true);
                this.rotateLeft(TMapIV.parentOf(x));
                x = this.root;
                continue;
            }
            sib = TMapIV.leftOf(TMapIV.parentOf(x));
            if (!TMapIV.colorOf(sib)) {
                TMapIV.setColor(sib, true);
                TMapIV.setColor(TMapIV.parentOf(x), false);
                this.rotateRight(TMapIV.parentOf(x));
                sib = TMapIV.leftOf(TMapIV.parentOf(x));
            }
            if (TMapIV.colorOf(TMapIV.rightOf(sib)) && TMapIV.colorOf(TMapIV.leftOf(sib))) {
                TMapIV.setColor(sib, false);
                x = TMapIV.parentOf(x);
                continue;
            }
            if (TMapIV.colorOf(TMapIV.leftOf(sib))) {
                TMapIV.setColor(TMapIV.rightOf(sib), true);
                TMapIV.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TMapIV.leftOf(TMapIV.parentOf(x));
            }
            TMapIV.setColor(sib, TMapIV.colorOf(TMapIV.parentOf(x)));
            TMapIV.setColor(TMapIV.parentOf(x), true);
            TMapIV.setColor(TMapIV.leftOf(sib), true);
            this.rotateRight(TMapIV.parentOf(x));
            x = this.root;
        }
        TMapIV.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (MapIV.Entry<V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<Integer> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, TMapIV.computeRedLevel(size), it, str, defaultVal);
    }

    private final Entry<V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        int key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry<V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                MapIV.Entry entry = (MapIV.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = (Integer)it.next();
                value = defaultVal;
            }
        } else {
            key = (Integer)str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<V> middle = new Entry<V>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry<V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    static final class Entry<V>
    implements MapIV.Entry<V> {
        int key;
        V value;
        Entry<V> left = null;
        Entry<V> right = null;
        Entry<V> parent;
        boolean color = true;

        Entry(int key, V value, Entry<V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MapIV.Entry)) {
                return false;
            }
            MapIV.Entry e = (MapIV.Entry)o;
            return this.key == e.getKey() && TMapIV.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key;
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static final class DescendingSubMap<V>
    extends NavigableSubMap<V> {
        private static final long serialVersionUID = 912986545866120460L;

        DescendingSubMap(TMapIV<V> m, boolean fromStart, int lo, boolean loInclusive, boolean toEnd, int hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public NavigableMapIV<V> subMap(int fromKey, boolean fromInclusive, int toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public NavigableMapIV<V> headMap(int toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMapIV<V> tailMap(int fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        @Override
        public NavigableMapIV<V> descendingMap() {
            AscendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<Integer> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        Iterator<Integer> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<MapIV.Entry<V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new DescendingEntrySetView();
        }

        @Override
        Entry<V> subLowest() {
            return this.absHighest();
        }

        @Override
        Entry<V> subHighest() {
            return this.absLowest();
        }

        @Override
        Entry<V> subCeiling(int key) {
            return this.absFloor(key);
        }

        @Override
        Entry<V> subHigher(int key) {
            return this.absLower(key);
        }

        @Override
        Entry<V> subFloor(int key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<V> subLower(int key) {
            return this.absHigher(key);
        }

        @Override
        public Collection<V> values() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsValue(V value) {
            return false;
        }

        @Override
        public void putAll(MapIV<V> m) {
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<MapIV.Entry<V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    static final class AscendingSubMap<V>
    extends NavigableSubMap<V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TMapIV<V> m, boolean fromStart, int lo, boolean loInclusive, boolean toEnd, int hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public NavigableMapIV<V> subMap(int fromKey, boolean fromInclusive, int toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public NavigableMapIV<V> headMap(int toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public NavigableMapIV<V> tailMap(int fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMapIV<V> descendingMap() {
            DescendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<Integer> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Iterator<Integer> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<MapIV.Entry<V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new AscendingEntrySetView();
        }

        @Override
        Entry<V> subLowest() {
            return this.absLowest();
        }

        @Override
        Entry<V> subHighest() {
            return this.absHighest();
        }

        @Override
        Entry<V> subCeiling(int key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<V> subHigher(int key) {
            return this.absHigher(key);
        }

        @Override
        Entry<V> subFloor(int key) {
            return this.absFloor(key);
        }

        @Override
        Entry<V> subLower(int key) {
            return this.absLower(key);
        }

        @Override
        public Collection<V> values() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsValue(V value) {
            return false;
        }

        @Override
        public void putAll(MapIV<V> m) {
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<MapIV.Entry<V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    static abstract class NavigableSubMap<V>
    implements NavigableMapIV<V>,
    Serializable {
        final TMapIV<V> m;
        final int lo;
        final int hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMapIV<V> descendingMapView = null;
        transient EntrySetView entrySetView = null;
        transient KeySet navigableKeySetView = null;

        NavigableSubMap(TMapIV<V> m, boolean fromStart, int lo, boolean loInclusive, boolean toEnd, int hi, boolean hiInclusive) {
            if (!fromStart && !toEnd) {
                if (m.compare(lo, hi) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    m.compare(lo, lo);
                }
                if (!toEnd) {
                    m.compare(hi, hi);
                }
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        final boolean tooLow(int key) {
            int c;
            return !this.fromStart && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        final boolean tooHigh(int key) {
            int c;
            return !this.toEnd && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        final boolean inRange(int key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        final boolean inClosedRange(int key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        final boolean inRange(int key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        final Entry<V> absLowest() {
            Entry<V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<V> absHighest() {
            Entry<V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<V> absCeiling(int key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<V> e = this.m.getCeilingEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<V> absHigher(int key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<V> absFloor(int key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<V> e = this.m.getFloorEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<V> absLower(int key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        final Entry<V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        abstract Entry<V> subLowest();

        abstract Entry<V> subHighest();

        abstract Entry<V> subCeiling(int var1);

        abstract Entry<V> subHigher(int var1);

        abstract Entry<V> subFloor(int var1);

        abstract Entry<V> subLower(int var1);

        abstract Iterator<Integer> keyIterator();

        abstract Iterator<Integer> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(int key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        @Override
        public final V put(int key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public final V get(int key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final V remove(int key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public final MapIV.Entry<V> ceilingEntry(int key) {
            return TMapIV.exportEntry(this.subCeiling(key));
        }

        @Override
        public final int ceilingKey(int key) {
            return this.subCeiling((int)key).key;
        }

        @Override
        public final MapIV.Entry<V> higherEntry(int key) {
            return TMapIV.exportEntry(this.subHigher(key));
        }

        @Override
        public final int higherKey(int key) {
            return this.subHigher((int)key).key;
        }

        @Override
        public final MapIV.Entry<V> floorEntry(int key) {
            return TMapIV.exportEntry(this.subFloor(key));
        }

        @Override
        public final int floorKey(int key) {
            return this.subFloor((int)key).key;
        }

        @Override
        public final MapIV.Entry<V> lowerEntry(int key) {
            return TMapIV.exportEntry(this.subLower(key));
        }

        @Override
        public final int lowerKey(int key) {
            return this.subLower((int)key).key;
        }

        @Override
        public final int firstKey() {
            return this.subLowest().key;
        }

        @Override
        public final int lastKey() {
            return this.subHighest().key;
        }

        @Override
        public final MapIV.Entry<V> firstEntry() {
            return TMapIV.exportEntry(this.subLowest());
        }

        @Override
        public final MapIV.Entry<V> lastEntry() {
            return TMapIV.exportEntry(this.subHighest());
        }

        @Override
        public final MapIV.Entry<V> pollFirstEntry() {
            Entry<V> e = this.subLowest();
            MapIV.Entry<V> result = TMapIV.exportEntry(e);
            if (e != null) {
                ((TMapIV)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final MapIV.Entry<V> pollLastEntry() {
            Entry<V> e = this.subHighest();
            MapIV.Entry<V> result = TMapIV.exportEntry(e);
            if (e != null) {
                ((TMapIV)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final NavigableSet<Integer> navigableKeySet() {
            KeySet nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<Integer> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<Integer> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMapIV<V> subMap(int fromKey, int toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMapIV<V> headMap(int toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final SortedMapIV<V> tailMap(int fromKey) {
            return this.tailMap(fromKey, true);
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<Integer> {
            DescendingSubMapKeyIterator(Entry<V> last, Entry<V> fence) {
                super(last, fence);
            }

            @Override
            public Integer next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<MapIV.Entry<V>> {
            DescendingSubMapEntryIterator(Entry<V> last, Entry<V> fence) {
                super(last, fence);
            }

            @Override
            public MapIV.Entry<V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<Integer> {
            SubMapKeyIterator(Entry<V> first, Entry<V> fence) {
                super(first, fence);
            }

            @Override
            public Integer next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<MapIV.Entry<V>> {
            SubMapEntryIterator(Entry<V> first, Entry<V> fence) {
                super(first, fence);
            }

            @Override
            public MapIV.Entry<V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        abstract class SubMapIterator<T>
        implements Iterator<T> {
            Entry<V> lastReturned;
            Entry<V> next;
            final int fenceKey;
            int expectedModCount;

            SubMapIterator(Entry<V> first, Entry<V> fence) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = first;
                this.fenceKey = fence == null ? null : Integer.valueOf(fence.key);
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            final Entry<V> nextEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TMapIV.successor(e);
                this.lastReturned = e;
                return e;
            }

            final Entry<V> prevEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TMapIV.predecessor(e);
                this.lastReturned = e;
                return e;
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<MapIV.Entry<V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                Entry n = NavigableSubMap.this.absLowest();
                return n == null || NavigableSubMap.this.tooHigh(n.key);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof MapIV.Entry)) {
                    return false;
                }
                MapIV.Entry entry = (MapIV.Entry)o;
                int key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                return node != null && TMapIV.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof MapIV.Entry)) {
                    return false;
                }
                MapIV.Entry entry = (MapIV.Entry)o;
                int key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                if (node != null && TMapIV.valEquals(node.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }
        }
    }

    public static class SimpleImmutableEntry<V>
    implements MapIV.Entry<V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        private final int key;
        private final V value;

        public SimpleImmutableEntry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleImmutableEntry(Entry<? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MapIV.Entry)) {
                return false;
            }
            MapIV.Entry e = (MapIV.Entry)o;
            return this.key == e.getKey() && TMapIV.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<Integer> {
        DescendingKeyIterator(Entry<V> first) {
            super(first);
        }

        @Override
        public Integer next() {
            return this.prevEntry().key;
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<Integer> {
        KeyIterator(Entry<V> first) {
            super(first);
        }

        @Override
        public Integer next() {
            return this.nextEntry().key;
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<MapIV.Entry<V>> {
        EntryIterator(Entry<V> first) {
            super(first);
        }

        @Override
        public MapIV.Entry<V> next() {
            return this.nextEntry();
        }
    }

    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        Entry<V> next;
        Entry<V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(Entry<V> first) {
            this.expectedModCount = TMapIV.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TMapIV.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TMapIV.successor(e);
            this.lastReturned = e;
            return e;
        }

        final Entry<V> prevEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TMapIV.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TMapIV.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TMapIV.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TMapIV.this.deleteEntry(this.lastReturned);
            this.expectedModCount = TMapIV.this.modCount;
            this.lastReturned = null;
        }
    }

    static final class KeySet
    extends AbstractSet<Integer>
    implements NavigableSet<Integer> {
        private final NavigableMapIV<?> m;

        KeySet(NavigableMapIV<?> map) {
            this.m = map;
        }

        @Override
        public Iterator<Integer> iterator() {
            if (this.m instanceof TMapIV) {
                return ((TMapIV)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public Iterator<Integer> descendingIterator() {
            if (this.m instanceof TreeMap) {
                return ((TMapIV)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean contains(int o) {
            return this.m.containsKey(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Integer lower(Integer e) {
            return this.m.lowerKey(e);
        }

        @Override
        public Integer floor(Integer e) {
            return this.m.floorKey(e);
        }

        @Override
        public Integer ceiling(Integer e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public Integer higher(Integer e) {
            return this.m.higherKey(e);
        }

        @Override
        public Integer first() {
            return this.m.firstKey();
        }

        @Override
        public Integer last() {
            return this.m.lastKey();
        }

        @Override
        public Integer pollFirst() {
            MapIV.Entry<?> e = this.m.pollFirstEntry();
            return e == null ? null : Integer.valueOf(e.getKey());
        }

        @Override
        public Integer pollLast() {
            MapIV.Entry<?> e = this.m.pollLastEntry();
            return e == null ? null : Integer.valueOf(e.getKey());
        }

        public boolean remove(int o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public NavigableSet<Integer> subSet(int fromElement, boolean fromInclusive, int toElement, boolean toInclusive) {
            NavigableMapIV<?> nmap = this.m.subMap(fromElement, fromInclusive, toElement, toInclusive);
            TreeSet<Integer> t = new TreeSet<Integer>();
            for (MapIV.Entry entry : nmap.entrySet()) {
                t.add(entry.getKey());
            }
            return t;
        }

        @Override
        public NavigableSet<Integer> headSet(int toElement, boolean inclusive) {
            NavigableMapIV<?> nmap = this.m.headMap(toElement, inclusive);
            TreeSet<Integer> t = new TreeSet<Integer>();
            for (MapIV.Entry entry : nmap.entrySet()) {
                t.add(entry.getKey());
            }
            return t;
        }

        @Override
        public NavigableSet<Integer> tailSet(int fromElement, boolean inclusive) {
            NavigableMapIV<?> nmap = this.m.tailMap(fromElement, inclusive);
            TreeSet<Integer> t = new TreeSet<Integer>();
            for (MapIV.Entry entry : nmap.entrySet()) {
                t.add(entry.getKey());
            }
            return t;
        }

        @Override
        public SortedSet<Integer> subSet(int fromElement, int toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<Integer> headSet(int toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<Integer> tailSet(int fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<Integer> descendingSet() {
            NavigableMapIV<?> nmap = this.m.descendingMap();
            TreeSet<Integer> t = new TreeSet<Integer>();
            for (MapIV.Entry entry : nmap.entrySet()) {
                t.add(entry.getKey());
            }
            return t;
        }

        @Override
        public SortedSet<Integer> headSet(Integer toElement) {
            return null;
        }

        @Override
        public NavigableSet<Integer> headSet(Integer toElement, boolean inclusive) {
            return null;
        }

        @Override
        public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
            return null;
        }

        @Override
        public NavigableSet<Integer> subSet(Integer fromElement, boolean fromInclusive, Integer toElement, boolean toInclusive) {
            return null;
        }

        @Override
        public SortedSet<Integer> tailSet(Integer fromElement) {
            return null;
        }

        @Override
        public NavigableSet<Integer> tailSet(Integer fromElement, boolean inclusive) {
            return null;
        }

        @Override
        public Comparator<? super Integer> comparator() {
            return null;
        }
    }

    class EntrySet
    extends AbstractSet<MapIV.Entry<V>> {
        EntrySet() {
        }

        @Override
        public Iterator<MapIV.Entry<V>> iterator() {
            return new EntryIterator(TMapIV.this.getFirstEntry());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof MapIV.Entry)) {
                return false;
            }
            MapIV.Entry entry = (MapIV.Entry)o;
            Object value = entry.getValue();
            Entry p = TMapIV.this.getEntry(entry.getKey());
            return p != null && TMapIV.valEquals(p.getValue(), value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof MapIV.Entry)) {
                return false;
            }
            MapIV.Entry entry = (MapIV.Entry)o;
            Object value = entry.getValue();
            Entry p = TMapIV.this.getEntry(entry.getKey());
            if (p != null && TMapIV.valEquals(p.getValue(), value)) {
                TMapIV.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return TMapIV.this.size();
        }

        @Override
        public void clear() {
            TMapIV.this.clear();
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(TMapIV.this.getFirstEntry());
        }

        @Override
        public int size() {
            return TMapIV.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TMapIV.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Entry e = TMapIV.this.getFirstEntry();
            while (e != null) {
                if (TMapIV.valEquals(e.getValue(), o)) {
                    TMapIV.this.deleteEntry(e);
                    return true;
                }
                e = TMapIV.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            TMapIV.this.clear();
        }
    }
}

