/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.map;

import com.google.common.collect.Sets;
import edu.umd.cloud9.util.map.MapIV;
import edu.umd.cloud9.util.map.TMapIV;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class TMapIVTest {
    @org.junit.Test
    public void testBasic1() {
        TMapIV<String> map = new TMapIV<String>();
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)map.isEmpty());
        map.put(2, "foo");
        Assert.assertFalse((boolean)map.isEmpty());
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        map.put(2, "foo");
        map.put(52, "bar");
        map.put(1, "baz");
        map.put(51, "a");
        map.put(99, "b");
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((Object)"foo", map.get(2));
        Assert.assertEquals((Object)"bar", map.get(52));
        Assert.assertEquals((Object)"baz", map.get(1));
        Assert.assertEquals((Object)"a", map.get(51));
        Assert.assertEquals((Object)"b", map.get(99));
        Iterator iter = map.entrySet().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        MapIV.Entry entry = iter.next();
        Assert.assertEquals((long)1L, (long)entry.getKey());
        Assert.assertEquals((Object)"baz", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((long)2L, (long)entry.getKey());
        Assert.assertEquals((Object)"foo", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((long)51L, (long)entry.getKey());
        Assert.assertEquals((Object)"a", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((long)52L, (long)entry.getKey());
        Assert.assertEquals((Object)"bar", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((long)99L, (long)entry.getKey());
        Assert.assertEquals((Object)"b", entry.getValue());
    }

    @org.junit.Test
    public void testBasic2() {
        int size = 100000;
        Random r = new Random();
        TreeSet ints = Sets.newTreeSet();
        TMapIV<String> map = new TMapIV<String>();
        for (int i = 0; i < size; ++i) {
            int rand = r.nextInt(size);
            if (ints.contains(rand)) continue;
            map.put(rand, rand + "");
            ints.add(rand);
        }
        for (Integer rand : ints) {
            String v = (String)map.get(rand);
            Assert.assertEquals((Object)v, (Object)(rand + ""));
            Assert.assertTrue((boolean)map.containsKey(rand));
        }
        Iterator gIter = ints.iterator();
        for (MapIV.Entry entry : map.entrySet()) {
            Assert.assertTrue((boolean)gIter.hasNext());
            Assert.assertEquals((long)((Integer)gIter.next()).intValue(), (long)entry.getKey());
        }
        Assert.assertFalse((boolean)gIter.hasNext());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TMapIVTest.class);
    }
}

