/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.pair;

import com.google.common.collect.Lists;
import edu.umd.cloud9.util.pair.PairOfObjectDouble;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfObjectDoubleTest {
    @org.junit.Test
    public void test1() {
        PairOfObjectDouble<String> pair = new PairOfObjectDouble<String>("a", 1.0);
        Assert.assertEquals((Object)"a", (Object)pair.getLeftElement());
        Assert.assertEquals((double)1.0, (double)pair.getRightElement(), (double)1.0E-5);
        pair.setLeftElement("b");
        Assert.assertEquals((Object)"b", (Object)pair.getLeftElement());
        pair.setRightElement(5.0);
        Assert.assertEquals((double)5.0, (double)pair.getRightElement(), (double)1.0E-5);
        pair.set("foo", -1.0);
        Assert.assertEquals((Object)"foo", (Object)pair.getLeftElement());
        Assert.assertEquals((double)-1.0, (double)pair.getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testIterable() {
        ArrayList list = Lists.newArrayList();
        list.add(new PairOfObjectDouble<String>("f", 9.0));
        list.add(new PairOfObjectDouble<String>("a", 1.0));
        list.add(new PairOfObjectDouble<String>("b", 4.0));
        list.add(new PairOfObjectDouble<String>("b", 2.0));
        list.add(new PairOfObjectDouble<String>("c", 2.0));
        list.add(new PairOfObjectDouble<String>("a", 3.0));
        Assert.assertEquals((long)6L, (long)list.size());
        Collections.sort(list);
        Assert.assertEquals((Object)"a", ((PairOfObjectDouble)list.get(0)).getLeftElement());
        Assert.assertEquals((double)1.0, (double)((PairOfObjectDouble)list.get(0)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"a", ((PairOfObjectDouble)list.get(1)).getLeftElement());
        Assert.assertEquals((double)3.0, (double)((PairOfObjectDouble)list.get(1)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"b", ((PairOfObjectDouble)list.get(2)).getLeftElement());
        Assert.assertEquals((double)2.0, (double)((PairOfObjectDouble)list.get(2)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"b", ((PairOfObjectDouble)list.get(3)).getLeftElement());
        Assert.assertEquals((double)4.0, (double)((PairOfObjectDouble)list.get(3)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"c", ((PairOfObjectDouble)list.get(4)).getLeftElement());
        Assert.assertEquals((double)2.0, (double)((PairOfObjectDouble)list.get(4)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"f", ((PairOfObjectDouble)list.get(5)).getLeftElement());
        Assert.assertEquals((double)9.0, (double)((PairOfObjectDouble)list.get(5)).getRightElement(), (double)1.0E-5);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfObjectDoubleTest.class);
    }
}

