/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.util.pair;

import com.google.common.collect.Lists;
import edu.umd.cloud9.util.pair.PairOfObjectFloat;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfObjectFloatTest {
    @org.junit.Test
    public void test1() {
        PairOfObjectFloat<String> pair = new PairOfObjectFloat<String>("a", 1.0f);
        Assert.assertEquals((Object)"a", (Object)pair.getLeftElement());
        Assert.assertEquals((double)1.0, (double)pair.getRightElement(), (double)1.0E-5);
        pair.setLeftElement("b");
        Assert.assertEquals((Object)"b", (Object)pair.getLeftElement());
        pair.setRightElement(5.0f);
        Assert.assertEquals((double)5.0, (double)pair.getRightElement(), (double)1.0E-5);
        pair.set("foo", -1.0f);
        Assert.assertEquals((Object)"foo", (Object)pair.getLeftElement());
        Assert.assertEquals((double)-1.0, (double)pair.getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testIterable() {
        ArrayList list = Lists.newArrayList();
        list.add(new PairOfObjectFloat<String>("f", 9.0f));
        list.add(new PairOfObjectFloat<String>("a", 1.0f));
        list.add(new PairOfObjectFloat<String>("b", 4.0f));
        list.add(new PairOfObjectFloat<String>("b", 2.0f));
        list.add(new PairOfObjectFloat<String>("c", 2.0f));
        list.add(new PairOfObjectFloat<String>("a", 3.0f));
        Assert.assertEquals((long)6L, (long)list.size());
        Collections.sort(list);
        Assert.assertEquals((Object)"a", ((PairOfObjectFloat)list.get(0)).getLeftElement());
        Assert.assertEquals((double)1.0, (double)((PairOfObjectFloat)list.get(0)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"a", ((PairOfObjectFloat)list.get(1)).getLeftElement());
        Assert.assertEquals((double)3.0, (double)((PairOfObjectFloat)list.get(1)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"b", ((PairOfObjectFloat)list.get(2)).getLeftElement());
        Assert.assertEquals((double)2.0, (double)((PairOfObjectFloat)list.get(2)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"b", ((PairOfObjectFloat)list.get(3)).getLeftElement());
        Assert.assertEquals((double)4.0, (double)((PairOfObjectFloat)list.get(3)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"c", ((PairOfObjectFloat)list.get(4)).getLeftElement());
        Assert.assertEquals((double)2.0, (double)((PairOfObjectFloat)list.get(4)).getRightElement(), (double)1.0E-5);
        Assert.assertEquals((Object)"f", ((PairOfObjectFloat)list.get(5)).getLeftElement());
        Assert.assertEquals((double)9.0, (double)((PairOfObjectFloat)list.get(5)).getRightElement(), (double)1.0E-5);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfObjectFloatTest.class);
    }
}

