/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.trecweb.Gov2DocnoMapping;
import edu.umd.cloud9.collection.trecweb.TrecWebDocumentInputFormat;
import edu.umd.cloud9.collection.trecweb.Wt10gDocnoMapping;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CollectionConfigurationManager {
    public static final String[] supported = new String[]{"trecweb", "gov2", "wt10g"};
    private boolean userSpecifiedInputFormat = false;
    private boolean userSpecifiedDocnoMapping = false;
    private int tgtConf = -1;
    private Class<? extends InputFormat<?, ?>> userSpecifiedInputFormatClass;
    private String userSpecifiedDocnoMappingClass;

    public static boolean isSupported(String tgtCollection) {
        return CollectionConfigurationManager.getCollectionIndex(tgtCollection) >= 0;
    }

    private static int getCollectionIndex(String tgtCollection) {
        tgtCollection = tgtCollection.toLowerCase();
        for (int i = 0; i < supported.length; ++i) {
            if (!tgtCollection.startsWith(supported[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean setConfByCollection(String collectionName) {
        int index = CollectionConfigurationManager.getCollectionIndex(collectionName);
        if (index == -1) {
            return false;
        }
        this.tgtConf = index;
        return true;
    }

    public boolean setUserSpecifiedInputFormat(String className) {
        Class<?> userClass;
        try {
            userClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (!FileInputFormat.class.isAssignableFrom(userClass)) {
            return false;
        }
        this.userSpecifiedInputFormat = true;
        this.userSpecifiedInputFormatClass = userClass;
        return true;
    }

    public boolean setUserSpecifiedDocnoMappingClass(String className) {
        Class<?> userClass;
        try {
            userClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (!DocnoMapping.class.isAssignableFrom(userClass)) {
            return false;
        }
        this.userSpecifiedDocnoMapping = true;
        this.userSpecifiedDocnoMappingClass = className;
        return true;
    }

    public void applyJobConfig(Job job) throws Exception {
        if (this.userSpecifiedInputFormat) {
            job.setInputFormatClass(this.userSpecifiedInputFormatClass);
        } else {
            switch (this.tgtConf) {
                case 0: 
                case 1: 
                case 2: {
                    job.setInputFormatClass(TrecWebDocumentInputFormat.class);
                    break;
                }
                default: {
                    throw new Exception("InputFormat class not specified");
                }
            }
        }
    }

    public void applyConfig(Configuration conf) throws Exception {
        if (this.userSpecifiedDocnoMapping) {
            conf.set("Cloud9.DocnoMappingClass", this.userSpecifiedDocnoMappingClass);
        } else {
            switch (this.tgtConf) {
                case 1: {
                    conf.set("Cloud9.DocnoMappingClass", Gov2DocnoMapping.class.getCanonicalName());
                    break;
                }
                case 2: {
                    conf.set("Cloud9.DocnoMappingClass", Wt10gDocnoMapping.class.getCanonicalName());
                    break;
                }
                default: {
                    throw new Exception("DocnoMapping class not specified");
                }
            }
        }
    }
}

