/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.data;

import edu.umd.cloud9.webgraph.data.AnchorText;
import edu.umd.cloud9.webgraph.data.AnchorTextConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class AnchorTextTest {
    @org.junit.Test
    public void testConstructors() {
        AnchorText anchor = new AnchorText();
        Assert.assertTrue((boolean)anchor.isInternalInLink());
        Assert.assertEquals((Object)anchor.getText(), (Object)"");
        Assert.assertEquals((long)anchor.getSize(), (long)0L);
        Assert.assertEquals((double)anchor.getWeight(), (double)0.0, (double)1.0E-100);
        AnchorText anchor2 = new AnchorText(AnchorTextConstants.Type.EXTERNAL_IN_LINK.val, "text");
        Assert.assertEquals((Object)anchor2.getText(), (Object)"text");
        Assert.assertEquals((long)anchor2.getSize(), (long)0L);
        AnchorText anchor3 = new AnchorText(AnchorTextConstants.Type.EXTERNAL_OUT_LINK.val, "text");
        Assert.assertNull((Object)anchor3.getText());
        Assert.assertEquals((long)anchor3.getSize(), (long)0L);
        AnchorText anchor4 = new AnchorText(AnchorTextConstants.Type.DOCNO_FIELD.val, "text", 100);
        Assert.assertNull((Object)anchor4.getText());
        Assert.assertEquals((long)anchor4.getSize(), (long)1L);
    }

    @org.junit.Test
    public void testClone() {
        AnchorText anchor1 = new AnchorText(AnchorTextConstants.Type.EXTERNAL_OUT_LINK.val, "text", 1);
        AnchorText anchor2 = anchor1.clone();
        anchor2.setText("some text");
        Assert.assertTrue((boolean)anchor2.equals(anchor1));
        anchor2.addDocument(2);
        Assert.assertNull((Object)anchor2.getText());
        Assert.assertEquals((long)anchor2.getSize(), (long)2L);
        Assert.assertTrue((boolean)anchor2.equalsIgnoreSources(anchor1));
        AnchorText anchor3 = new AnchorText(AnchorTextConstants.Type.DOCNO_FIELD.val, "text");
        anchor3.addDocumentsFrom(anchor2);
        anchor3.addDocument(2);
        Assert.assertNull((Object)anchor3.getText());
        Assert.assertEquals((long)anchor3.getSize(), (long)2L);
        anchor3.setWeight(1.0f);
        Assert.assertEquals((double)anchor3.getWeight(), (double)0.0, (double)1.0E-100);
        Assert.assertEquals((long)anchor3.compareTo(anchor2), (long)1L);
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bstream);
        try {
            anchor3.write(out);
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bstream.toByteArray()));
        AnchorText readAnchor = new AnchorText();
        try {
            readAnchor.readFields(in);
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)anchor3, (Object)readAnchor);
        Assert.assertTrue((boolean)anchor3.intersects(anchor2));
        Assert.assertTrue((boolean)anchor3.containsDocument(2));
        anchor3.resetToType(AnchorTextConstants.Type.IN_DEGREE.val);
        Assert.assertNull((Object)anchor3.getText());
        anchor3.resetToType(AnchorTextConstants.Type.INTERNAL_IN_LINK.val);
        Assert.assertEquals((Object)anchor3.getText(), (Object)"");
        Assert.assertTrue((boolean)anchor3.isInternalInLink());
        Assert.assertEquals((long)anchor3.getSize(), (long)0L);
        Assert.assertEquals((double)anchor3.getWeight(), (double)0.0, (double)1.0E-100);
        Assert.assertFalse((boolean)anchor3.containsDocument(3));
        Assert.assertFalse((boolean)anchor3.intersects(anchor2));
    }

    @org.junit.Test
    public void testIterable() {
        AnchorText anchor = new AnchorText(AnchorTextConstants.Type.EXTERNAL_IN_LINK.val, "text");
        anchor.addDocument(1);
        anchor.addDocument(2);
        anchor.addDocument(3);
        int[] sources = anchor.getDocuments();
        Assert.assertEquals((long)sources[0], (long)1L);
        Assert.assertEquals((long)sources[1], (long)2L);
        Assert.assertEquals((long)sources[2], (long)3L);
        anchor.resetToType(AnchorTextConstants.Type.URL_FIELD.val);
        Assert.assertEquals((long)anchor.getSize(), (long)0L);
        for (int s : anchor) {
            Assert.fail();
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(AnchorTextTest.class);
    }
}

