/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.data;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.DocumentForwardIndex;
import edu.umd.cloud9.io.array.ArrayListWritable;
import edu.umd.cloud9.webgraph.data.AnchorText;
import edu.umd.cloud9.webgraph.data.IndexableAnchorText;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class IndexableAnchorTextForwardIndex
implements DocumentForwardIndex<IndexableAnchorText> {
    private static final IndexableAnchorText indexableAnchorText = new IndexableAnchorText();
    private static final DecimalFormat df = new DecimalFormat("00000");
    private Configuration conf;
    private FileSystem fs;
    private int[] docnos;
    private int[] offsets;
    private short[] filenos;
    private String collectionPath;
    private DocnoMapping docnoMapping;
    private int mLastDocno = -1;

    public IndexableAnchorTextForwardIndex(DocnoMapping docnoMapping) {
        this.docnoMapping = docnoMapping;
    }

    @Override
    public void loadIndex(Path index, Path mapping, FileSystem fs) throws IOException {
        this.docnoMapping.loadMapping(mapping, fs);
        FSDataInputStream in = fs.open(index);
        in.readUTF();
        this.collectionPath = in.readUTF();
        int blocks = in.readInt();
        this.docnos = new int[blocks];
        this.offsets = new int[blocks];
        this.filenos = new short[blocks];
        for (int i = 0; i < blocks; ++i) {
            this.docnos[i] = in.readInt();
            this.offsets[i] = in.readInt();
            this.filenos[i] = in.readShort();
        }
        in.close();
    }

    @Override
    public String getCollectionPath() {
        return this.collectionPath;
    }

    @Override
    public IndexableAnchorText getDocument(int docno) {
        int idx = Arrays.binarySearch(this.docnos, docno);
        if (idx < 0) {
            idx = -idx - 2;
        }
        DecimalFormat df = new DecimalFormat("00000");
        String file = this.collectionPath + "/part-" + df.format(this.filenos[idx]);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, new Path(file), this.conf);
            IntWritable key = new IntWritable();
            ArrayListWritable<AnchorText> value = new ArrayListWritable<AnchorText>();
            reader.seek((long)this.offsets[idx]);
            while (reader.next((Writable)key) && key.get() != docno) {
            }
            reader.getCurrentValue(value);
            reader.close();
            indexableAnchorText.createHTML(value);
            return indexableAnchorText;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IndexableAnchorText getDocument(String docid) {
        return this.getDocument(this.docnoMapping.getDocno(docid));
    }

    @Override
    public int getDocno(String docid) {
        return this.docnoMapping.getDocno(docid);
    }

    @Override
    public String getDocid(int docno) {
        return this.docnoMapping.getDocid(docno);
    }

    @Override
    public int getFirstDocno() {
        return this.docnos[0];
    }

    @Override
    public int getLastDocno() {
        if (this.mLastDocno != -1) {
            return this.mLastDocno;
        }
        int idx = this.docnos.length - 1;
        String file = this.collectionPath + "/part-" + df.format(this.filenos[idx]);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, new Path(file), this.conf);
            IntWritable key = new IntWritable();
            reader.seek((long)this.offsets[idx]);
            while (reader.next((Writable)key)) {
            }
            this.mLastDocno = key.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.mLastDocno;
    }

    public String getContentType() {
        return "text/html";
    }

    public String getDisplayContentType() {
        return "text/html";
    }
}

