/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.driver;

import edu.umd.cloud9.io.array.ArrayListWritable;
import edu.umd.cloud9.mapred.NoSplitSequenceFileInputFormat;
import edu.umd.cloud9.webgraph.data.AnchorText;
import edu.umd.cloud9.webgraph.data.IndexableAnchorTextForwardIndex;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class BuildAnchorTextForwardIndex
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(BuildAnchorTextForwardIndex.class);

    private static int printUsage() {
        System.out.println("usage: [collection-path] [output-path] [index-file]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 3) {
            BuildAnchorTextForwardIndex.printUsage();
            return -1;
        }
        JobConf conf = new JobConf(this.getConf());
        FileSystem fs = FileSystem.get((Configuration)conf);
        String collectionPath = args[0];
        String outputPath = args[1];
        String indexFile = args[2];
        LOG.info((Object)"Tool name: BuildAnchorTextForwardIndex");
        LOG.info((Object)(" - collection path: " + collectionPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - index file: " + indexFile));
        LOG.info((Object)"Note: This tool only works on block-compressed SequenceFiles!");
        conf.set("mapred.child.java.opts", "-Xmx2048m");
        conf.setJobName("BuildAnchorTextForwardIndex");
        conf.setNumMapTasks(100);
        conf.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(collectionPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(NoSplitSequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapRunnerClass(MyMapRunner.class);
        conf.setReducerClass(IdentityReducer.class);
        fs.delete(new Path(outputPath), true);
        RunningJob job = JobClient.runJob((JobConf)conf);
        Counters counters = job.getCounters();
        int blocks = (int)((Counters.Counter)counters.findCounter((Enum)Blocks.Total)).getCounter();
        LOG.info((Object)("number of blocks: " + blocks));
        LOG.info((Object)"Writing index file...");
        LineReader reader = new LineReader((InputStream)fs.open(new Path(outputPath + "/part-00000")));
        FSDataOutputStream out = fs.create(new Path(indexFile), true);
        out.writeUTF(IndexableAnchorTextForwardIndex.class.getName());
        out.writeUTF(collectionPath);
        out.writeInt(blocks);
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\s+");
            int docno = Integer.parseInt(arr[0]);
            int offset = Integer.parseInt(arr[1]);
            short fileno = Short.parseShort(arr[2]);
            out.writeInt(docno);
            out.writeInt(offset);
            out.writeShort((int)fileno);
            if (++cnt % 1000 != 0) continue;
            LOG.info((Object)(cnt + " blocks written"));
        }
        reader.close();
        out.close();
        if (cnt != blocks) {
            throw new RuntimeException("Error: mismatch in block count!");
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new BuildAnchorTextForwardIndex(), (String[])args);
        System.exit(res);
    }

    private static class MyMapRunner
    implements MapRunnable<IntWritable, ArrayListWritable<AnchorText>, IntWritable, Text> {
        private static int fileno;
        private static final IntWritable sOutputKey;
        private static final Text sOutputValue;

        private MyMapRunner() {
        }

        public void configure(JobConf job) {
            String file = job.get("map.input.file");
            fileno = Integer.parseInt(file.substring(file.indexOf("part-") + 5));
        }

        public void run(RecordReader<IntWritable, ArrayListWritable<AnchorText>> input, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            IntWritable key = new IntWritable();
            ArrayListWritable value = new ArrayListWritable();
            long pos = -1L;
            long prevPos = -1L;
            int prevDocno = 0;
            pos = input.getPos();
            while (input.next((Object)key, value)) {
                if (prevPos != -1L && prevPos != pos) {
                    LOG.info((Object)("- beginning of block at " + prevPos + ", docno:" + prevDocno + ", file:" + fileno));
                    sOutputKey.set(prevDocno);
                    sOutputValue.set(prevPos + "\t" + fileno);
                    output.collect((Object)sOutputKey, (Object)sOutputValue);
                    reporter.incrCounter((Enum)Blocks.Total, 1L);
                }
                prevPos = pos;
                pos = input.getPos();
                prevDocno = key.get();
            }
        }

        static {
            sOutputKey = new IntWritable();
            sOutputValue = new Text();
        }
    }

    private static enum Blocks {
        Total;

    }
}

