/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.alignment.aer.ReferenceAlignment;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import junit.framework.TestCase;

public class AlignmentTest
extends TestCase {
    Alignment a = new Alignment(6, 5);
    File temp;
    DataInputStream dis;

    public AlignmentTest() {
        this.a.align(0, 0);
        this.a.align(2, 1);
        this.a.align(1, 2);
        this.a.align(5, 2);
        this.a.align(3, 3);
        this.a.align(4, 4);
    }

    protected void createFiles() throws Exception {
        super.setUp();
        File temp = File.createTempFile("align", null);
        temp.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
        this.a.write(dos);
        dos.close();
        this.dis = new DataInputStream(new FileInputStream(temp));
    }

    protected void deleteFiles() throws Exception {
        super.tearDown();
        this.dis.close();
    }

    public void testReadFields() {
        Alignment b = new Alignment();
        try {
            this.createFiles();
            b.readFields(this.dis);
            Alignment c = Alignment.union(this.a, b);
            AlignmentTest.assertTrue((boolean)b.equals(this.a));
            AlignmentTest.assertTrue((boolean)b.equals(c));
            Alignment d = Alignment.union(this.a, b);
            AlignmentTest.assertTrue((boolean)b.equals(d));
            this.deleteFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testEmptyAlignment() {
        Alignment c = new Alignment(4, 4, "");
        AlignmentTest.assertFalse((boolean)c.aligned(0, 0));
        AlignmentTest.assertEquals((String)c.toString(), (String)"");
    }

    public void testUnalignF() {
        Alignment b = (Alignment)this.a.clone();
        b.unalignF(1);
        AlignmentTest.assertTrue((boolean)this.a.aligned(1, 2));
        AlignmentTest.assertFalse((boolean)b.aligned(1, 2));
    }

    public void testAlignment() {
        Alignment c = new Alignment(2, 2, "0-1 1-1");
        AlignmentTest.assertTrue((boolean)c.aligned(0, 1));
        AlignmentTest.assertTrue((boolean)c.aligned(1, 1));
        AlignmentTest.assertFalse((boolean)c.aligned(0, 0));
        AlignmentTest.assertFalse((boolean)c.aligned(1, 0));
        try {
            Alignment err = new Alignment(2, 2, "1-2");
            System.err.println(err);
            AlignmentTest.assertTrue((boolean)false);
        }
        catch (Exception e) {
            AlignmentTest.assertTrue((boolean)true);
        }
    }

    public void testNeighborAligned() {
        AlignmentTest.assertFalse((boolean)this.a.neighborAligned(0, 0));
    }

    public void testLneighborAligned() {
        AlignmentTest.assertTrue((boolean)this.a.neighborAligned(3, 2));
    }

    public void testIterator() {
        Alignment b = new Alignment(10, 10);
        AlignmentTest.assertFalse((boolean)b.iterator().hasNext());
        int sum = 0;
        for (Alignment.IntPair i : this.a) {
            sum += i.f;
        }
        AlignmentTest.assertEquals((int)sum, (int)15);
        Iterator<Alignment.IntPair> i = this.a.iterator();
        Alignment.IntPair first = i.next();
        AlignmentTest.assertEquals((int)first.f, (int)0);
        AlignmentTest.assertEquals((int)first.e, (int)0);
        Alignment.IntPair sec = i.next();
        AlignmentTest.assertEquals((int)sec.f, (int)2);
        AlignmentTest.assertEquals((int)i.next().f, (int)1);
        AlignmentTest.assertEquals((int)i.next().f, (int)5);
        AlignmentTest.assertEquals((int)i.next().f, (int)3);
        AlignmentTest.assertEquals((int)i.next().e, (int)4);
        AlignmentTest.assertFalse((boolean)i.hasNext());
    }

    public void testCountNeighbors() {
        AlignmentTest.assertEquals((int)this.a.countNeighbors(0, 1, Alignment.DIAG_NEIGHBORS), (int)2);
    }

    public void testGetELength() {
        AlignmentTest.assertEquals((int)this.a.getELength(), (int)5);
    }

    public void testGetFLength() {
        AlignmentTest.assertEquals((int)this.a.getFLength(), (int)6);
    }

    public void testAligned() {
        AlignmentTest.assertTrue((boolean)this.a.aligned(0, 0));
    }

    public void testMergeEnglishWords() {
        AlignmentTest.assertTrue((boolean)this.a.aligned(0, 0));
        Alignment x = this.a.mergeEnglishWords(1, 2).mergeEnglishWords(2, 3);
        System.err.println(x.toStringVisual());
    }

    public void testSplitEnglishWords() {
        AlignmentTest.assertTrue((boolean)this.a.aligned(0, 0));
        Alignment x = this.a;
        System.err.println(x.toStringVisual());
        x = this.a.splitEnglishWords(0);
        System.err.println(x.toStringVisual());
    }

    public void testSplitForeignWords() {
        AlignmentTest.assertTrue((boolean)this.a.aligned(0, 0));
        System.err.println("FOREIGN");
        Alignment x = this.a;
        System.err.println(x.toStringVisual());
        x = this.a.splitForeignWords(0);
        System.err.println(x.toStringVisual());
    }

    public void testAlign() {
        Alignment b = (Alignment)this.a.clone();
        AlignmentTest.assertTrue((boolean)b.equals(this.a));
        b.align(0, 4);
        AlignmentTest.assertTrue((boolean)b.aligned(0, 4));
        Alignment c = Alignment.intersect(this.a, b);
        AlignmentTest.assertTrue((boolean)c.equals(this.a));
        AlignmentTest.assertFalse((boolean)c.equals(b));
    }

    public void testFromGiza() {
        String eline = "a la bruja -ja verde";
        String fline = "NULL ({ 1 }) the ({ 2 }) green ({ 5 }) witch ({ 3 })";
        Alignment b = Alignment.fromGiza(eline, fline, false);
        Alignment c = Alignment.fromGiza(eline, fline, true);
        AlignmentTest.assertTrue((boolean)c.getTranspose().equals(b));
        AlignmentTest.assertEquals((int)b.getELength(), (int)5);
        AlignmentTest.assertEquals((int)b.getFLength(), (int)3);
        AlignmentTest.assertEquals((int)c.getELength(), (int)3);
        AlignmentTest.assertEquals((int)c.getFLength(), (int)5);
        String eline2 = "the green witch";
        String fline2 = "NULL ({ }) a ({ }) la ({ 1 }) bruja ({ 3 }) -ja ({ 3 }) verde ({ 2 })";
        Alignment x = Alignment.fromGiza(eline2, fline2, false);
        Alignment union = Alignment.union(c, x);
        AlignmentTest.assertFalse((boolean)union.equals(c));
    }

    public void testGetTranspose() {
        Alignment b = this.a.getTranspose();
        AlignmentTest.assertEquals((int)this.a.getELength(), (int)b.getFLength());
        AlignmentTest.assertEquals((int)b.getELength(), (int)this.a.getFLength());
    }

    public void testToString() {
        AlignmentTest.assertEquals((String)this.a.toString(), (String)"0-0 1-2 2-1 3-3 4-4 5-2");
    }

    public void testIntersect() {
        Alignment a = new Alignment(2, 2);
        Alignment b = new Alignment(2, 2);
        a.align(1, 1);
        a.align(0, 0);
        b.align(0, 1);
        b.align(1, 0);
        Alignment c = Alignment.intersect(a, b);
        Alignment d = new Alignment(2, 2);
        AlignmentTest.assertTrue((boolean)d.equals(c));
        b.align(0, 0);
        c = Alignment.intersect(a, b);
        AlignmentTest.assertTrue((boolean)c.aligned(0, 0));
        AlignmentTest.assertFalse((boolean)c.aligned(0, 1));
        AlignmentTest.assertFalse((boolean)c.aligned(1, 1));
        AlignmentTest.assertFalse((boolean)c.aligned(1, 0));
    }

    public void testUnion() {
        Alignment a = new Alignment(2, 2);
        Alignment b = new Alignment(2, 2);
        a.align(1, 1);
        a.align(0, 0);
        b.align(0, 1);
        b.align(1, 0);
        Alignment c = Alignment.union(a, b);
        AlignmentTest.assertTrue((boolean)c.aligned(0, 0));
        AlignmentTest.assertTrue((boolean)c.aligned(1, 1));
        AlignmentTest.assertTrue((boolean)c.aligned(1, 0));
        AlignmentTest.assertTrue((boolean)c.aligned(0, 1));
    }

    public void testReference() {
        ReferenceAlignment ra = new ReferenceAlignment(4, 5);
        ra.align(0, 0);
        ra.sureAlign(1, 1);
        ra.sureAlign(3, 4);
        ra.align(2, 4);
        Alignment a = new Alignment(4, 5);
        a.align(0, 1);
        a.align(1, 1);
        a.align(2, 4);
        a.align(1, 4);
        AlignmentTest.assertEquals((int)1, (int)ra.countSureHits(a));
    }
}

