/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Vocab;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparable;

public class FloatAugmentedPhrase
implements WritableComparable,
Cloneable {
    byte _language;
    int[] _words;
    float[] _values;

    public Object clone() {
        FloatAugmentedPhrase res = new FloatAugmentedPhrase();
        res._language = this._language;
        if (this._words != null) {
            res._words = (int[])this._words.clone();
        }
        if (this._values != null) {
            res._values = (float[])this._values.clone();
        }
        return res;
    }

    public FloatAugmentedPhrase() {
    }

    public FloatAugmentedPhrase(int[] p, int lang, float[] v) {
        this._language = (byte)lang;
        this._words = p;
        this._values = v;
    }

    public int size() {
        if (this._words == null) {
            return 0;
        }
        return this._words.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FloatAugmentedPhrase)) {
            return false;
        }
        FloatAugmentedPhrase that = (FloatAugmentedPhrase)o;
        if (this._language != that._language) {
            return false;
        }
        if (that._words.length != this._words.length) {
            return false;
        }
        if (Arrays.equals(this._words, that._words)) {
            return false;
        }
        return Arrays.equals(this._values, that._values);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("[L=").append(this._language);
        if (this._words != null) {
            for (i = 0; i < this._words.length; ++i) {
                sb.append(' ').append(this._words[i]);
            }
        }
        if (this._values != null) {
            for (i = 0; i < this._words.length; ++i) {
                sb.append(' ').append(this._values[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int compareTo(Object o) {
        FloatAugmentedPhrase that = (FloatAugmentedPhrase)o;
        if (this._language != that._language) {
            return that._language - this._language;
        }
        if (this._words == null || that._words == null) {
            int a = 0;
            if (this._words != null) {
                a = this._words.length;
            }
            int b = 0;
            if (that._words != null) {
                b = that._words.length;
            }
            return b - a;
        }
        for (int i = 0; i < this._words.length && i < that._words.length; ++i) {
            int a = this._words[i];
            int b = that._words[i];
            if (a == b) continue;
            return a - b;
        }
        return this._words.length - that._words.length;
    }

    public int hashCode() {
        int i;
        int hc = this._language + 73;
        if (this._words != null) {
            for (i = 0; i < this._words.length; ++i) {
                hc = 31 * hc + this._words[i];
            }
        }
        if (this._values != null) {
            for (i = 0; i < this._values.length; ++i) {
                hc = 31 * hc + (int)((double)this._values[i] * 31415.9);
            }
        }
        return hc;
    }

    public String toString(Vocab voc) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this._words != null) {
            for (i = 0; i < this._words.length; ++i) {
                if (i != 0) {
                    sb.append(' ');
                }
                sb.append(voc.get(this._words[i]));
            }
        }
        if (this._values != null) {
            for (i = 0; i < this._values.length; ++i) {
                if (i != 0) {
                    sb.append(' ');
                }
                sb.append(this._values[i]);
            }
        }
        return sb.toString();
    }

    public int[] getWords() {
        return this._words;
    }

    public float[] getValues() {
        return this._values;
    }

    public byte getLanguage() {
        return this._language;
    }

    public void setLanguage(int l) {
        this._language = (byte)l;
    }

    public FloatAugmentedPhrase getSubPhrase(int start, int end) {
        FloatAugmentedPhrase res = new FloatAugmentedPhrase();
        res._language = this._language;
        res._words = new int[end - start + 1];
        System.arraycopy(this._words, start, res._words, 0, end - start + 1);
        System.arraycopy(this._values, start, res._values, 0, end - start + 1);
        return res;
    }

    public static FloatAugmentedPhrase fromString(int lang, String sentence, Vocab voc) {
        throw new UnsupportedOperationException();
    }

    public void readFields(DataInput in) throws IOException {
        this._language = in.readByte();
        int bbLen = in.readInt();
        if (bbLen == 0) {
            this._words = null;
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        IntBuffer ib = bb.asIntBuffer();
        this._words = new int[bbLen / 4];
        ib.get(this._words);
        if (bbLen == 0) {
            this._values = null;
            return;
        }
        bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        FloatBuffer fb = bb.asFloatBuffer();
        this._values = new float[bbLen / 4];
        fb.get(this._values);
    }

    public void setWords(int[] words) {
        this._words = words;
    }

    public void setValues(float[] values) {
        this._values = values;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this._language);
        int bbLen = 0;
        if (this._words != null) {
            bbLen = this._words.length * 4;
        }
        out.writeInt(bbLen);
        if (bbLen == 0) {
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(this._words);
        out.write(bb.array());
        bb = ByteBuffer.allocate(bbLen);
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(this._values);
        out.write(bb.array());
    }
}

