/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.PServerClient;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.ttables.TTable;
import edu.umd.hooka.ttables.TTable_monolithic_IFAs;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class PServer
implements Runnable {
    private TTable ttable;
    ServerSocketChannel serverChannel;
    Selector selector = null;
    long reqs = 0L;
    int i = 0;
    int connections = 0;
    HashMap<SelectionKey, ByteBuffer> key2buf = new HashMap();
    HashMap<SelectionKey, ByteBuffer> key2obuf = new HashMap();
    static final int READ_BUFFER_SIZE = 35000;
    static final int WRITE_BUFFER_SIZE = 300000;

    public static void main(String[] args) {
        try {
            PServer v = null;
            ByteBuffer b = ByteBuffer.allocate(20);
            FloatBuffer fb = b.asFloatBuffer();
            fb.put(0.1f);
            fb.flip();
            System.out.println(fb.position() + "=fpos   bpos=" + b.position());
            Thread t = new Thread(v);
            t.start();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            PServerClient psc = new PServerClient("localhost", 4444);
            int[] e = new int[]{201, 202, 203, 1000000, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
            int[] f = new int[]{101, 102, 103, 104, 105, 106, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 2, 3, 5, 3, 4, 2, 3, 4, 5, 3, 2, 5, 6, 7, 12345, 34};
            PhrasePair pp = new PhrasePair(new Phrase(e, 0), new Phrase(f, 1));
            psc.query(pp, true);
            e = new int[]{201, 202, 203, 2, 2, 2};
            f = new int[]{101, 102, 103, 6, 7, 12345, 34};
            pp = new PhrasePair(new Phrase(f, 0), new Phrase(e, 1));
            psc.query(pp, true);
            float va = psc.get(2, 34);
            System.out.println(va);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            v.stopServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PServer(int port, FileSystem fs, Path ttablePath) throws IOException {
        this.ttable = new TTable_monolithic_IFAs(fs, ttablePath, true);
        this.serverChannel = ServerSocketChannel.open();
        this.selector = Selector.open();
        this.serverChannel.socket().bind(new InetSocketAddress(port));
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector, 16);
        System.err.println("PServer initialized on " + InetAddress.getLocalHost() + ":" + port);
    }

    public void stopServer() {
        System.err.println("Stopping PServer...");
        try {
            this.selector.close();
            this.serverChannel.close();
        }
        catch (Exception e) {
            System.err.println("Caught " + e);
        }
    }

    @Override
    public void run() {
        System.err.println("PServer running.");
        block4: while (true) {
            try {
                this.selector.select();
            }
            catch (IOException e) {
                System.err.println("Caught exception in select()");
                e.printStackTrace();
                break;
            }
            if (!this.selector.isOpen()) break;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (true) {
                if (!it.hasNext()) continue block4;
                SelectionKey key = it.next();
                try {
                    this.processSelectionKey(key);
                }
                catch (IOException e) {
                    key.cancel();
                    System.err.println("Caught exception handling selection key. Key cancelled");
                }
                it.remove();
            }
            break;
        }
        System.err.println("Server exiting.");
        System.err.println("  " + this.reqs + " requests processed");
        System.err.println("  " + this.connections + " connections");
    }

    protected void processSelectionKey(SelectionKey key) throws IOException {
        if (key.isAcceptable()) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(this.selector, 1);
            ++this.connections;
        } else if (key.isReadable()) {
            SocketChannel sc;
            int num;
            ByteBuffer in_bb = this.key2buf.get(key);
            ByteBuffer out_bb = this.key2obuf.get(key);
            if (in_bb == null) {
                System.err.println("Allocating new buffer!");
                in_bb = ByteBuffer.allocate(35000);
                this.key2buf.put(key, in_bb);
                out_bb = ByteBuffer.allocate(300000);
                this.key2obuf.put(key, out_bb);
            }
            if ((num = (sc = (SocketChannel)key.channel()).read(in_bb)) == -1) {
                System.out.println("closing");
                this.key2buf.remove(key);
                sc.close();
                return;
            }
            if (in_bb.position() < 8) {
                return;
            }
            int elen = in_bb.getInt(0);
            if (elen < 1) {
                throw new RuntimeException("Elen is out of bounds! elen=" + elen);
            }
            int pl = in_bb.position();
            if (elen > pl) {
                return;
            }
            in_bb.flip();
            in_bb.getInt();
            int fplen = in_bb.getInt();
            IntBuffer ib = in_bb.asIntBuffer();
            int[] ep = new int[fplen];
            ib.get(ep, 0, fplen);
            int[] fp = new int[ib.remaining()];
            ib.get(fp);
            int sz = fp.length * ep.length * 32 / 8;
            out_bb.putInt(sz);
            for (int e : ep) {
                for (int f : fp) {
                    out_bb.putFloat(this.ttable.get(e, f));
                }
            }
            ++this.reqs;
            out_bb.flip();
            int x = sc.write(out_bb);
            if (x != sz + 4) {
                System.err.println("Failed to write " + sz + " bytes!  Wrote " + x + " bytes");
            }
            in_bb.rewind();
            in_bb.limit(35000);
            out_bb.rewind();
            out_bb.limit(300000);
        } else if (key.isWritable()) {
            throw new IOException("Received writable key - not expecting!");
        }
    }
}

