/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.VocabularyWritable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;

public class PhrasePairTest
extends TestCase {
    VocabularyWritable ve = new VocabularyWritable();
    VocabularyWritable vf = new VocabularyWritable();
    PhrasePair pp;
    PhrasePair pp2;

    public PhrasePairTest(String name) {
        super(name);
        this.vf.addOrGet("verde");
        String eline = "a la bruja -ja verde";
        String fline = "NULL ({ 1 }) the ({ 2 }) green ({ 5 }) witch ({ 3 4 })";
        Alignment c = Alignment.fromGiza(eline, fline, true);
        String eline2 = "the green witch";
        String fline2 = "NULL ({ }) a ({ }) la ({ 1 }) bruja ({ 3 }) -ja ({ }) verde ({ 2 })";
        Alignment x = Alignment.fromGiza(eline2, fline2, false);
        Alignment union = Alignment.union(c, x);
        this.pp = new PhrasePair(eline, this.vf, eline2, this.ve, union.toString());
        this.pp2 = new PhrasePair(eline, this.vf, eline2, this.ve, Alignment.intersect(c, x).toString());
    }

    public void testToString() {
        PhrasePairTest.assertEquals((String)"{F:[L=1 2 3 4 5 1] ||| E:[L=0 1 2 3] ||| A: 1-0 2-2 3-2 4-1}", (String)this.pp.toString());
    }

    public void testExtractAlmostMinimalBoundedPhrasePairContainingE() {
        PhrasePair x = this.pp2.extractMinimalConsistentPhrasePairContainingESpan(0, 0);
        PhrasePairTest.assertEquals((String)"la ||| the ||| 0-0", (String)x.toString(this.vf, this.ve));
        x = this.pp2.extractMinimalConsistentPhrasePairContainingESpan(1, 2);
        PhrasePairTest.assertEquals((String)"bruja -ja verde ||| green witch ||| 0-1 2-0", (String)x.toString(this.vf, this.ve));
    }

    public void testToStringVocabVocab() {
        PhrasePairTest.assertEquals((String)"a la bruja -ja verde ||| the green witch ||| 1-0 2-2 3-2 4-1", (String)this.pp.toString(this.vf, this.ve));
    }

    public void testMergeEnglishWords() {
        PhrasePair x = new PhrasePair("x x x x", this.vf, "al- kitab al- jadyd", this.ve, "0-0 1-1 2-2 3-3");
        x.mergeEnglishWords(2, 3, this.ve.addOrGet("al-jadyd"));
        String res = x.toString(this.vf, this.ve);
        PhrasePairTest.assertEquals((String)"x x x x ||| al- kitab al-jadyd ||| 0-0 1-1 2-2 3-2", (String)res);
        System.err.println(res);
        x = new PhrasePair("x x x x y", this.vf, "reiste am fruehen morgen ab-", this.ve, "");
        x.setAlignment(null);
        x.mergeEnglishWords(0, 4, this.ve.addOrGet("abreiste"));
        res = x.toString(this.vf, this.ve);
        PhrasePairTest.assertEquals((String)"x x x x y ||| abreiste am fruehen morgen", (String)res);
        x = new PhrasePair("x x x x y", this.vf, "reiste am fruehen morgen ab-", this.ve, "");
        x.setAlignment(null);
        x.mergeEnglishWords(4, 0, this.ve.addOrGet("abreiste"));
        res = x.toString(this.vf, this.ve);
        PhrasePairTest.assertEquals((String)"x x x x y ||| am fruehen morgen abreiste", (String)res);
    }

    public void testGetE() {
        PhrasePairTest.assertEquals((int)3, (int)this.pp.getE().size());
    }

    public void testGetF() {
        PhrasePairTest.assertEquals((int)5, (int)this.pp.getF().size());
    }

    public void testSetE() {
        PhrasePair pt = (PhrasePair)this.pp.clone();
        PhrasePairTest.assertTrue((boolean)pt.equals(this.pp));
        Phrase e = pt.getE();
        Phrase empty = new Phrase();
        pt.setAlignment(null);
        PhrasePairTest.assertTrue((pt.compareTo(this.pp) == 0 ? 1 : 0) != 0);
        pt.setE(empty);
        PhrasePairTest.assertTrue((pt.compareTo(this.pp) != 0 ? 1 : 0) != 0);
        PhrasePairTest.assertEquals((int)pt.compareTo(this.pp), (int)(-this.pp.compareTo(pt)));
        pt.setF(e);
        PhrasePairTest.assertTrue((pt.compareTo(this.pp) != 0 ? 1 : 0) != 0);
    }

    public void testHasAlignment() {
        PhrasePairTest.assertTrue((boolean)this.pp.hasAlignment());
    }

    public void testEquals() {
        PhrasePairTest.assertFalse((boolean)this.pp.equals(this.pp2));
    }

    public void testHashCode() {
        PhrasePairTest.assertEquals((int)this.pp.hashCode(), (int)this.pp2.hashCode());
    }

    public void testWrite() {
        try {
            File temp = File.createTempFile("phrpr", null);
            temp.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
            this.pp.write(dos);
            this.pp2.write(dos);
            PhrasePair px = new PhrasePair(this.pp.getF(), this.pp.getE());
            px.write(dos);
            System.out.println(this.pp.toString(this.vf, this.ve));
            System.out.println(this.pp2.toString(this.vf, this.ve));
            System.out.println(px.toString(this.vf, this.ve));
            dos.close();
            System.err.println("Size of PPs on disk: " + dos.size());
            DataInputStream dis = new DataInputStream(new FileInputStream(temp));
            PhrasePair pl = new PhrasePair();
            pl.readFields(dis);
            PhrasePairTest.assertEquals((String)this.pp.toString(this.vf, this.ve), (String)pl.toString(this.vf, this.ve));
            PhrasePairTest.assertTrue((boolean)pl.equals(this.pp));
        }
        catch (IOException e) {
            e.printStackTrace();
            PhrasePairTest.fail((String)("Caught " + e));
        }
    }

    public void testExtractConsistentPhrasePairs() {
        ArrayList<PhrasePair> ps = this.pp.extractConsistentPhrasePairs(6);
        ArrayList<PhrasePair.SubPhraseCoordinates> pc = this.pp.extractConsistentSubPhraseCoordinates(6);
        PhrasePairTest.assertEquals((int)ps.size(), (int)7);
        PhrasePairTest.assertEquals((int)ps.size(), (int)7);
        for (int i = 0; i < 7; ++i) {
            PhrasePair a = ps.get(i);
            PhrasePair b = this.pp.extractSubPhrasePair(pc.get(i));
            PhrasePairTest.assertTrue((boolean)a.equals(b));
        }
        ps = this.pp.extractConsistentPhrasePairs(2);
        PhrasePairTest.assertEquals((int)ps.size(), (int)4);
        PhrasePairTest.assertEquals((int)this.pp.extractConsistentSubPhraseCoordinates(2).size(), (int)4);
        PhrasePairTest.assertTrue((boolean)ps.get(0).hasAlignment());
    }
}

