/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.FileListing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ProfileLogParser {
    static final int JOB_START = 0;
    static final int MAP_START = 1;
    static final int MAP_FINISH = 2;
    static final int REDUCE_START = 3;
    static final int REDUCE_FINISH = 4;
    static final int JOB_FINISH = 5;
    static final int INVALID = 6;

    public void Parse(Collection<File> theFiles, long startTime, long finishTime, OutputStream output) throws IOException {
        BufferedReader inputReader = null;
        BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter(output));
        HashMap<String, nodeData> dataHashMap = new HashMap<String, nodeData>();
        itemData currData = null;
        nodeData currNodeData = null;
        long jobStartTime = startTime;
        long jobFinishTime = finishTime;
        String currLine = null;
        for (File currFile : theFiles) {
            try {
                inputReader = new BufferedReader(new InputStreamReader(new FileInputStream(currFile)));
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                System.err.println("Input file not found");
                return;
            }
            currLine = inputReader.readLine();
            while (currLine != null) {
                currData = new itemData(currLine);
                if (currData.itemType == 6) {
                    currLine = inputReader.readLine();
                    continue;
                }
                if (currData.itemType == 0) {
                    jobStartTime = currData.timestamp;
                } else if (currData.itemType == 5) {
                    jobFinishTime = currData.timestamp;
                } else {
                    if (!dataHashMap.containsKey(currData.identifier)) {
                        dataHashMap.put(currData.identifier, new nodeData());
                    }
                    currNodeData = (nodeData)dataHashMap.get(currData.identifier);
                    switch (currData.itemType) {
                        case 1: {
                            currNodeData.mapStart = currData.timestamp;
                            break;
                        }
                        case 2: {
                            currNodeData.mapFinish = currData.timestamp;
                            break;
                        }
                        case 3: {
                            currNodeData.reduceStart = currData.timestamp;
                            break;
                        }
                        case 4: {
                            currNodeData.reduceFinish = currData.timestamp;
                        }
                    }
                }
                currLine = inputReader.readLine();
            }
        }
        int numNodes = 0;
        int failedReports = 0;
        long timeTaken = jobFinishTime - jobStartTime;
        long preMap = 0L;
        long mapTime = 0L;
        long intermediate = 0L;
        long reduceTime = 0L;
        long postReduce = 0L;
        for (nodeData x : dataHashMap.values()) {
            if (x.mapStart == 0L || x.mapFinish == 0L || x.reduceStart == 0L || x.reduceFinish == 0L) {
                ++failedReports;
                continue;
            }
            preMap += x.mapStart - jobStartTime;
            mapTime += x.mapFinish - x.mapStart;
            intermediate += x.reduceStart - x.mapFinish;
            reduceTime += x.reduceFinish - x.reduceStart;
            postReduce += jobFinishTime - x.reduceFinish;
            ++numNodes;
        }
        outputWriter.write(Integer.toString(numNodes) + " total nodes reporting for " + Long.toString(timeTaken) + " milliseconds each\n");
        outputWriter.write("Total node time taken before map operations: " + Long.toString(preMap) + "\n");
        outputWriter.write("Total node time taken for map operations: " + Long.toString(mapTime) + "\n");
        outputWriter.write("Total node time taken between map and reduce operations: " + Long.toString(intermediate) + "\n");
        outputWriter.write("Total node time taken for reduce operations: " + Long.toString(reduceTime) + "\n");
        outputWriter.write("Total node time taken after reduce operations: " + Long.toString(postReduce) + "\n");
        outputWriter.write(Integer.toString(failedReports) + " nodes reporting incomplete data (not counted in above) \n");
        outputWriter.close();
    }

    public static void main(String[] args) {
        String directory = "/home/guest/hadoop/logs/userlogs/thistask";
        long startTime = 1205673885264L;
        long finishTime = 1205673915411L;
        List<File> theFiles = null;
        try {
            theFiles = FileListing.getFileListing(new File(directory));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            new ProfileLogParser().Parse(theFiles, startTime, finishTime, System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class itemData {
        String identifier;
        int itemType;
        long timestamp;

        public itemData(String data) {
            StringTokenizer tokens = new StringTokenizer(data);
            String currToken = "";
            try {
                while (!currToken.endsWith(":")) {
                    currToken = tokens.nextToken();
                }
                currToken = tokens.nextToken();
                this.itemType = currToken.equals("JOB_START") ? 0 : (currToken.equals("MAP_START") ? 1 : (currToken.equals("MAP_FINISH") ? 2 : (currToken.equals("REDUCE_START") ? 3 : (currToken.equals("REDUCE_FINISH") ? 4 : (currToken.equals("JOB_FINISH") ? 5 : 6)))));
                this.identifier = currToken = tokens.nextToken();
                currToken = tokens.nextToken();
                this.timestamp = Long.parseLong(currToken);
            }
            catch (NoSuchElementException e) {
                this.itemType = 6;
            }
            catch (NumberFormatException e) {
                this.itemType = 6;
            }
        }
    }

    private class nodeData {
        long mapStart;
        long mapFinish;
        long reduceStart;
        long reduceFinish;

        private nodeData() {
        }
    }
}

