/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Vocab;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class VocabularyWritable
implements Writable,
Vocab {
    private static final Logger sLogger = Logger.getLogger(VocabularyWritable.class);
    ArrayList<String> strings = new ArrayList();
    HashMap<String, Integer> map;

    public VocabularyWritable() {
        this.strings.add("NULL");
        this.map = new HashMap();
        this.map.put("NULL", new Integer(0));
    }

    @Override
    public int size() {
        return this.strings.size();
    }

    @Override
    public int addOrGet(String word) {
        Integer i = this.map.get(word);
        if (i == null) {
            i = new Integer(this.strings.size());
            this.strings.add(word);
            this.map.put(word, i);
        }
        return i;
    }

    @Override
    public int get(String word) {
        if (this.map.get(word) == null) {
            return -1;
        }
        return this.map.get(word);
    }

    @Override
    public String get(int index) {
        return this.strings.get(index);
    }

    public void readFields(DataInput in) throws IOException {
        int s = in.readInt();
        sLogger.info((Object)("VOCAB SIZE " + s));
        this.strings = new ArrayList(s);
        this.map = new HashMap();
        Text t = new Text();
        for (int i = 0; i < s; ++i) {
            t.readFields(in);
            String str = t.toString();
            this.strings.add(i, str);
            this.map.put(str, new Integer(i));
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.strings.size());
        Text t = new Text();
        for (String s : this.strings) {
            t.set(s);
            t.write(out);
        }
    }

    public String toString() {
        return this.strings.toString();
    }
}

