/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.VocabularyWritable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class VocabularyWritableTest
extends TestCase {
    VocabularyWritable v;
    int hello;
    int goodbye;
    int bar;

    protected void setUp() throws Exception {
        super.setUp();
        this.v = new VocabularyWritable();
        this.hello = this.v.addOrGet("hello");
        this.goodbye = this.v.addOrGet("Goodbye");
        this.bar = this.v.addOrGet("bar");
    }

    public void testSize() {
        VocabularyWritableTest.assertEquals((int)this.v.size(), (int)4);
        this.v.addOrGet("foo");
        VocabularyWritableTest.assertEquals((int)this.v.size(), (int)5);
    }

    public void testAddOrGet() {
        String baz = "baz";
        int i = this.v.addOrGet(baz);
        VocabularyWritableTest.assertEquals((String)this.v.get(i), (String)baz);
        String h = "h";
        String ello = h + "ello";
        VocabularyWritableTest.assertEquals((int)this.v.addOrGet(ello), (int)this.hello);
    }

    public void testGetString() {
        String a = "Good";
        String b = a + "bye";
        VocabularyWritableTest.assertEquals((int)this.v.get(b), (int)this.goodbye);
    }

    public void testGetInt() {
        VocabularyWritableTest.assertEquals((String)this.v.get(this.bar), (String)"bar");
    }

    public void testReadFields() {
        try {
            File temp = File.createTempFile("phrpr", null);
            temp.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
            this.v.write(dos);
            dos.close();
            System.err.println("Size of voc on disk: " + dos.size());
            DataInputStream dis = new DataInputStream(new FileInputStream(temp));
            VocabularyWritable vw = new VocabularyWritable();
            vw.readFields(dis);
            VocabularyWritableTest.assertEquals((String)this.v.get(this.bar), (String)vw.get(this.bar));
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            VocabularyWritableTest.fail((String)("Caught " + e));
        }
    }
}

